/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.util.registry.IRegistry;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncThread;

final class TCPWriterThread
extends AbstractAsyncThread {
    private static final Log LOG = LogFactory.getLog(TCPWriterThread.class);
    private final SocketChannel socketChannel;
    private final ByteBuffer byteBuffer;
    private final IRegistry<String> stringRegistry;
    private final boolean flush;

    public TCPWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, String hostname, int port, int bufferSize, boolean flush) throws IOException {
        super(monitoringController, writeQueue);
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.socketChannel = SocketChannel.open(new InetSocketAddress(hostname, port));
        this.stringRegistry = this.monitoringController.getStringRegistry();
        this.flush = flush;
    }

    @Override
    protected void consume(IMonitoringRecord monitoringRecord) throws Exception {
        if (monitoringRecord instanceof RegistryRecord) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(monitoringRecord.getSize());
            monitoringRecord.writeBytes(buffer, this.stringRegistry);
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.socketChannel.write(buffer);
            }
        } else {
            ByteBuffer buffer = this.byteBuffer;
            if (monitoringRecord.getSize() + 4 + 8 > buffer.remaining()) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    this.socketChannel.write(buffer);
                }
                buffer.clear();
            }
            buffer.putInt(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
            buffer.putLong(monitoringRecord.getLoggingTimestamp());
            monitoringRecord.writeBytes(buffer, this.stringRegistry);
            if (this.flush) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    this.socketChannel.write(buffer);
                }
                buffer.clear();
            }
        }
    }

    @Override
    protected void cleanup() {
        try {
            ByteBuffer buffer = this.byteBuffer;
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.socketChannel.write(buffer);
            }
            this.socketChannel.close();
        }
        catch (IOException ex) {
            LOG.error("Error closing connection", ex);
        }
    }
}

