/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.filesystem.BinaryCompressionMethod;
import kieker.common.util.registry.IRegistry;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public class BinaryFsWriterThread
extends AbstractFsWriterThread {
    private static final Log LOG = LogFactory.getLog(BinaryFsWriterThread.class);
    private DataOutputStream out;
    private final int bufferSize;
    private final BinaryCompressionMethod compressionMethod;
    private final IRegistry<String> stringRegistry;

    public BinaryFsWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int maxLogSize, int maxLogFiles, int bufferSize, BinaryCompressionMethod compressionMethod) {
        super(monitoringController, writeQueue, mappingFileWriter, path, maxEntriesInFile, maxLogSize, maxLogFiles);
        this.compressionMethod = compressionMethod;
        this.fileExtension = compressionMethod.getFileExtension();
        this.bufferSize = bufferSize;
        this.stringRegistry = monitoringController.getStringRegistry();
    }

    @Override
    protected void write(IMonitoringRecord monitoringRecord) throws IOException {
        int size = monitoringRecord.getSize() + 4 + 8;
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.putInt(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
        buffer.putLong(monitoringRecord.getLoggingTimestamp());
        monitoringRecord.writeBytes(buffer, this.stringRegistry);
        byte[] bytes = new byte[size];
        buffer.flip();
        buffer.get(bytes, 0, size);
        this.out.write(bytes);
    }

    @Override
    protected void prepareFile(String filename) throws IOException {
        if (null != this.out) {
            this.out.close();
        }
        this.out = this.compressionMethod.getDataOutputStream(new File(filename), this.bufferSize);
    }

    @Override
    protected void cleanup() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close channel.", ex);
            }
        }
    }
}

