/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncThread;
import kieker.monitoring.writer.database.DBWriterHelper;

final class DbWriterThread
extends AbstractAsyncThread {
    private static final Log LOG = LogFactory.getLog(DbWriterThread.class);
    private final Connection connection;
    private final DBWriterHelper helper;
    private final ConcurrentMap<Class<? extends IMonitoringRecord>, PreparedStatement> recordTypeInformation = new ConcurrentHashMap<Class<? extends IMonitoringRecord>, PreparedStatement>();
    private final AtomicLong recordId;

    public DbWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> blockingQueue, String connectionString, String tablePrefix, AtomicInteger tableCounter, AtomicLong recordId, boolean overwrite) throws SQLException {
        super(monitoringController, blockingQueue);
        this.recordId = recordId;
        this.connection = DriverManager.getConnection(connectionString);
        this.helper = new DBWriterHelper(this.connection, tablePrefix, tableCounter, overwrite);
    }

    @Override
    protected final void consume(IMonitoringRecord record) throws Exception {
        Class<?> recordClass = record.getClass();
        String recordClassName = recordClass.getSimpleName();
        if (!this.recordTypeInformation.containsKey(recordClass)) {
            Class<?>[] typeArray;
            LOG.info("New record type found: " + recordClassName);
            try {
                typeArray = AbstractMonitoringRecord.typesForClass(recordClass);
            }
            catch (MonitoringRecordException ex) {
                throw new Exception("Failed to get types of record", ex);
            }
            try {
                String tableName = this.helper.createTable(recordClass.getName(), typeArray);
                StringBuilder sb = new StringBuilder("?,?");
                for (int count = typeArray.length; count > 0; --count) {
                    sb.append(",?");
                }
                PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + tableName + " VALUES (" + sb.toString() + ")");
                this.recordTypeInformation.put(recordClass, preparedStatement);
            }
            catch (SQLException ex) {
                if (null == ex.getSQLState()) {
                    LOG.error("Unable to log records of type " + recordClass.getName() + ": " + ex.getMessage());
                    return;
                }
                throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
            }
        }
        try {
            long id = this.recordId.getAndIncrement();
            PreparedStatement preparedStatement = (PreparedStatement)this.recordTypeInformation.get(recordClass);
            preparedStatement.setLong(1, id);
            preparedStatement.setLong(2, record.getLoggingTimestamp());
            Object[] recordFields = record.toArray();
            for (int i = 0; i < recordFields.length; ++i) {
                if (this.helper.set(preparedStatement, i + 3, recordFields[i])) continue;
                throw new Exception("Failed to add record to database.");
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
    }

    @Override
    protected void cleanup() {
        try {
            for (Class recordType : this.recordTypeInformation.keySet()) {
                PreparedStatement preparedStatement = (PreparedStatement)this.recordTypeInformation.remove(recordType);
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException ex) {
            LOG.error("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.toString());
        sb.append("; Connection: '");
        sb.append(this.connection.toString());
        sb.append("'; ");
        sb.append(this.helper.toString());
        return sb.toString();
    }
}

