/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.configuration;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public final class Configuration
extends Properties {
    private static final long serialVersionUID = 3364877592243422259L;
    private static final Log LOG = LogFactory.getLog(Configuration.class);

    public Configuration() {
        this((Properties)null);
    }

    public Configuration(Properties defaults) {
        super(defaults);
    }

    public final String getStringProperty(String key) {
        String s = super.getProperty(key);
        return s == null ? "" : s.trim();
    }

    public final boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getStringProperty(key));
    }

    public final int getIntProperty(String key) {
        String s = this.getStringProperty(key);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Error parsing configuration property '" + key + "', found value '" + s + "', using default value 0");
            return 0;
        }
    }

    public final long getLongProperty(String key) {
        String s = this.getStringProperty(key);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Error parsing configuration property '" + key + "', found value '" + s + "', using default value 0");
            return 0L;
        }
    }

    public final double getDoubleProperty(String key) {
        String s = this.getStringProperty(key);
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Error parsing configuration property '" + key + "', found value '" + s + "', using default value 0");
            return 0.0;
        }
    }

    public final String getPathProperty(String key) {
        return Configuration.convertToPath(this.getStringProperty(key));
    }

    public final String[] getStringArrayProperty(String key) {
        return this.getStringArrayProperty(key, "\\|");
    }

    public final void setStringArrayProperty(String key, String[] value) {
        this.setProperty(key, Configuration.toProperty(value));
    }

    public final String[] getStringArrayProperty(String key, String split) {
        String s = this.getStringProperty(key);
        if (s.length() == 0) {
            return new String[0];
        }
        return s.split(split);
    }

    public static final String toProperty(Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    public static final String convertToPath(String pathname) {
        if (pathname.length() == 0) {
            return pathname;
        }
        String workingPathname = pathname.replace('\\', '/');
        boolean endsWithSlash = workingPathname.charAt(workingPathname.length() - 1) == '/';
        String[] components = workingPathname.split("/");
        LinkedList<String> path = new LinkedList<String>();
        for (String component : components) {
            if (".".equals(component) || "".equals(component)) continue;
            if ("..".equals(component)) {
                if (!path.isEmpty() && !"..".equals(path.getLast())) {
                    path.removeLast();
                    continue;
                }
                path.add("..");
                continue;
            }
            path.add(component);
        }
        StringBuilder sb = new StringBuilder();
        if (workingPathname.charAt(0) == '/') {
            sb.append('/');
        }
        int numberPathElements = path.size();
        Iterator pathIter = path.iterator();
        for (int i = 0; i < numberPathElements - 1; ++i) {
            sb.append((String)pathIter.next()).append('/');
        }
        if (pathIter.hasNext()) {
            sb.append((String)pathIter.next());
        }
        if (endsWithSlash && sb.length() != 0 && (sb.length() != 1 || sb.charAt(0) != '/')) {
            sb.append('/');
        }
        String result = sb.toString();
        while (result.startsWith("/../")) {
            result = result.substring(3);
        }
        if ("/..".equals(result)) {
            result = "/";
        }
        return result;
    }

    public final Configuration getPropertiesStartingWith(String prefix) {
        Configuration configuration = new Configuration(null);
        Set<String> keys = this.stringPropertyNames();
        for (String property : keys) {
            if (!property.startsWith(prefix)) continue;
            configuration.setProperty(property, super.getProperty(property));
        }
        return configuration;
    }

    public final Configuration flatten(Configuration defaultConfiguration) {
        Configuration configuration = new Configuration(defaultConfiguration);
        Set<String> keys = this.stringPropertyNames();
        for (String property : keys) {
            configuration.setProperty(property, super.getProperty(property));
        }
        return configuration;
    }

    public final Configuration flatten() {
        return this.flatten(null);
    }

    public final void flattenInPlace() {
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            this.setProperty(property, super.getProperty(property));
        }
        this.defaults = null;
    }

    public final void setDefaultConfiguration(Configuration defaultConfiguration) {
        Configuration conf = this;
        while (conf.defaults != null && conf.defaults instanceof Configuration) {
            conf = (Configuration)conf.defaults;
        }
        if (conf.defaults == null) {
            conf.defaults = defaultConfiguration;
        } else if (defaultConfiguration != null) {
            this.flattenInPlace();
            this.defaults = defaultConfiguration;
        }
    }

    @Override
    @Deprecated
    public final synchronized Object put(Object key, Object value) {
        return super.put(key, value);
    }

    @Override
    @Deprecated
    public final synchronized Object get(Object key) {
        return super.get(key);
    }

    @Override
    @Deprecated
    public final String getProperty(String key) {
        return super.getProperty(key);
    }

    @Override
    @Deprecated
    public final String getProperty(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }
}

