/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib;

import java.util.concurrent.ConcurrentLinkedQueue;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.tslib.ITimeSeriesPointsBuffer;

public class TimeSeriesPointsBuffer<T>
extends ConcurrentLinkedQueue<T>
implements ITimeSeriesPointsBuffer<T> {
    private static final long serialVersionUID = -7988633509408488397L;
    private static final Log LOG = LogFactory.getLog(TimeSeriesPointsBuffer.class);
    private final int capacity;
    private final boolean unbounded;

    public TimeSeriesPointsBuffer() {
        this(-1);
    }

    public TimeSeriesPointsBuffer(int capacity) {
        this.capacity = capacity;
        this.unbounded = capacity <= 0;
    }

    @Override
    public synchronized boolean add(T o) {
        if (this.unbounded) {
            return super.add(o);
        }
        return this.addBounded(o);
    }

    private synchronized boolean addBounded(T o) {
        if (this.size() == this.capacity) {
            super.poll();
            return super.add(o);
        }
        return super.add(o);
    }

    @Override
    public T remove() {
        return (T)super.poll();
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public void printBuffer() {
        LOG.info(this.toString());
    }
}

