/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.record.StorableDetectionResult;

@Plugin(configuration={@Property(name="numberOfEntries", defaultValue="100")})
public class AnomalyScoreVisualizationFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES = "numberOfEntries";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_OF_ENTRIES = "100";
    private final XYPlot xyplot;
    private final int numberOfEntries;

    public AnomalyScoreVisualizationFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.numberOfEntries = configuration.getIntProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES);
        this.xyplot = new XYPlot(this.numberOfEntries);
    }

    @InputPort(name="inputEvents", eventTypes={StorableDetectionResult.class})
    public void inputNormal(StorableDetectionResult record) {
        this.updateDisplays(record);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES, String.valueOf(this.numberOfEntries));
        return configuration;
    }

    private void updateDisplays(StorableDetectionResult record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getTimestamp(), this.recordsTimeUnitFromProjectContext));
        String minutesAndSeconds = date.toString().substring(14, 19);
        this.xyplot.setEntry(record.getApplicationName() + " - Actual Value", minutesAndSeconds, record.getValue());
        this.xyplot.setEntry(record.getApplicationName() + " - Forecast", minutesAndSeconds, record.getForecast());
    }

    @Display(name="XYPlot Anomaly Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }
}

