/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.map;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.util.filesystem.FSUtil;

public final class MappingFileWriter {
    private final File mappingFile;

    public MappingFileWriter(String path) throws IOException {
        StringBuilder sbm = new StringBuilder(path.length() + 11);
        sbm.append(path).append(File.separatorChar).append("kieker.map");
        String mappingFileFn = sbm.toString();
        this.mappingFile = new File(mappingFileFn);
        if (!this.mappingFile.createNewFile()) {
            throw new IOException("Mapping File '" + mappingFileFn + "' already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(RegistryRecord hashRecord) throws IOException {
        File file = this.mappingFile;
        synchronized (file) {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mappingFile, true), "UTF-8"));
                pw.write(36);
                pw.write(String.valueOf(hashRecord.getId()));
                pw.write(61);
                pw.write(FSUtil.encodeNewline(hashRecord.getString()));
                pw.write(10);
                if (pw.checkError()) {
                    throw new IOException("Error writing to mappingFile " + this.mappingFile.toString());
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }
}

