/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.BlockingQueue;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.filesystem.BinaryCompressionMethod;
import kieker.common.util.registry.IRegistry;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public class BinaryNFsWriterThread
extends AbstractFsWriterThread {
    private static final Log LOG = LogFactory.getLog(BinaryNFsWriterThread.class);
    private FileOutputStream out;
    private FileChannel channel;
    private final ByteBuffer byteBuffer;
    private final IRegistry<String> stringRegistry;

    public BinaryNFsWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int maxLogSize, int maxLogFiles, int bufferSize) {
        super(monitoringController, writeQueue, mappingFileWriter, path, maxEntriesInFile, maxLogSize, maxLogFiles);
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.stringRegistry = monitoringController.getStringRegistry();
        this.fileExtension = BinaryCompressionMethod.NONE.getFileExtension();
    }

    @Override
    protected void write(IMonitoringRecord monitoringRecord) throws IOException {
        ByteBuffer buffer = this.byteBuffer;
        if (monitoringRecord.getSize() + 4 + 8 > buffer.remaining()) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.channel.write(buffer);
            }
            buffer.clear();
        }
        buffer.putInt(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
        buffer.putLong(monitoringRecord.getLoggingTimestamp());
        monitoringRecord.writeBytes(buffer, this.stringRegistry);
    }

    @Override
    protected void prepareFile(String filename) throws IOException {
        if (null != this.out) {
            ByteBuffer buffer = this.byteBuffer;
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.channel.write(buffer);
            }
            buffer.clear();
            this.channel.force(false);
            this.out.close();
        }
        this.out = new FileOutputStream(filename);
        this.channel = this.out.getChannel();
    }

    @Override
    protected void cleanup() {
        if (this.out != null) {
            try {
                ByteBuffer buffer = this.byteBuffer;
                buffer.flip();
                while (buffer.hasRemaining()) {
                    this.channel.write(buffer);
                }
                buffer.clear();
                this.channel.force(false);
                this.out.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close channel.", ex);
            }
        }
    }
}

