/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.util.registry.IRegistry;

public class ConstructionEvent
extends AbstractTraceEvent {
    public static final int SIZE = 28;
    private static final long serialVersionUID = -3519441499400826996L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, Integer.TYPE};
    public static final String CLASS_SIGNATURE = "";
    public static final int OBJECT_ID = 0;
    private final String classSignature;
    private final int objectId;

    public ConstructionEvent(long timestamp, long traceId, int orderIndex, String classSignature, int objectId) {
        super(timestamp, traceId, orderIndex);
        this.classSignature = classSignature == null ? CLASS_SIGNATURE : classSignature;
        this.objectId = objectId;
    }

    public ConstructionEvent(Object[] values) {
        super(values, TYPES);
        this.classSignature = (String)values[3];
        this.objectId = (Integer)values[4];
    }

    protected ConstructionEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.classSignature = (String)values[3];
        this.objectId = (Integer)values[4];
    }

    public ConstructionEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.classSignature = stringRegistry.get(buffer.getInt());
        this.objectId = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getClassSignature(), this.getObjectId()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putLong(this.getTraceId());
        buffer.putInt(this.getOrderIndex());
        buffer.putInt(stringRegistry.get(this.getClassSignature()));
        buffer.putInt(this.getObjectId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getClassSignature() {
        return this.classSignature;
    }

    public final int getObjectId() {
        return this.objectId;
    }
}

