/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public final class ToolsUtil {
    private static final Log LOG = LogFactory.getLog(ToolsUtil.class);

    private ToolsUtil() {
    }

    public static void loadVerboseLogger() {
        ToolsUtil.loadLogger("logging.verbose.properties");
    }

    public static void loadDebugLogger() {
        ToolsUtil.loadLogger("logging.debug.properties");
    }

    public static void loadDefaultLogger() {
        ToolsUtil.loadLogger("logging.properties");
    }

    private static void loadLogger(String loggerProperties) {
        try {
            LogManager logManager = LogManager.getLogManager();
            InputStream configStream = ClassLoader.getSystemClassLoader().getResourceAsStream(loggerProperties);
            if (configStream != null) {
                logManager.readConfiguration(configStream);
            } else {
                LOG.warn("Could not load verbose/debug logger");
            }
        }
        catch (SecurityException ex) {
            LOG.warn("Could not load verbose/debug logger", ex);
        }
        catch (IOException ex) {
            LOG.warn("Could not load verbose/debug logger", ex);
        }
    }
}

