/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib.anomalycalculators;

import kieker.tools.tslib.ITimeSeriesPoint;
import kieker.tools.tslib.anomalycalculators.AnomalyScore;
import kieker.tools.tslib.anomalycalculators.IAnomalyScoreCalculator;
import kieker.tools.tslib.forecast.IForecastResult;

public class SimpleAnomalyScoreCalculator
implements IAnomalyScoreCalculator<Double> {
    @Override
    public AnomalyScore calculateAnomalyScore(IForecastResult forecast, ITimeSeriesPoint<Double> current) {
        if (forecast.getForecast().getPoints().size() == 0) {
            return null;
        }
        Double nextpredicted = forecast.getForecast().getPoints().get(0).getValue();
        if (null == nextpredicted) {
            return null;
        }
        double measuredValue = 0.0;
        measuredValue = current.getValue();
        double difference = nextpredicted - measuredValue;
        double sum = nextpredicted + measuredValue;
        difference = Math.abs(difference / sum);
        return new AnomalyScore(difference);
    }
}

