/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.AnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.filter.flow.EventRecordTraceReconstructionFilter;
import kieker.analysis.plugin.filter.forward.StringBufferFilter;
import kieker.analysis.plugin.filter.select.TimestampFilter;
import kieker.analysis.plugin.filter.select.TraceIdFilter;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.AbstractCommandLineTool;
import kieker.tools.traceAnalysis.Constants;
import kieker.tools.traceAnalysis.filter.AbstractGraphProducingFilter;
import kieker.tools.traceAnalysis.filter.AbstractTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.IGraphOutputtingFilter;
import kieker.tools.traceAnalysis.filter.executionRecordTransformation.ExecutionRecordTransformationFilter;
import kieker.tools.traceAnalysis.filter.flow.EventRecordTraceCounter;
import kieker.tools.traceAnalysis.filter.flow.TraceEventRecords2ExecutionAndMessageTraceFilter;
import kieker.tools.traceAnalysis.filter.systemModel.SystemModel2FileFilter;
import kieker.tools.traceAnalysis.filter.traceFilter.TraceEquivalenceClassFilter;
import kieker.tools.traceAnalysis.filter.traceReconstruction.TraceReconstructionFilter;
import kieker.tools.traceAnalysis.filter.traceWriter.ExecutionTraceWriterFilter;
import kieker.tools.traceAnalysis.filter.traceWriter.InvalidExecutionTraceWriterFilter;
import kieker.tools.traceAnalysis.filter.traceWriter.MessageTraceWriterFilter;
import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.GraphWriterPlugin;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AggregatedAllocationComponentOperationCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AggregatedAssemblyComponentOperationCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.TraceCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentDependencyGraphAllocationFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentDependencyGraphAssemblyFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ContainerDependencyGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationDependencyGraphAllocationFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationDependencyGraphAssemblyFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ResponseTimeColorNodeDecorator;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ResponseTimeNodeDecorator;
import kieker.tools.traceAnalysis.filter.visualization.descriptions.DescriptionDecoratorFilter;
import kieker.tools.traceAnalysis.filter.visualization.sequenceDiagram.SequenceDiagramFilter;
import kieker.tools.traceAnalysis.filter.visualization.traceColoring.TraceColoringFilter;
import kieker.tools.traceAnalysis.repository.DescriptionRepository;
import kieker.tools.traceAnalysis.repository.TraceColorRepository;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.util.CLIHelpFormatter;
import kieker.tools.util.LoggingTimestampConverter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class TraceAnalysisTool
extends AbstractCommandLineTool {
    public static final String DATE_FORMAT_PATTERN_CMD_USAGE_HELP = "yyyyMMdd'-'HHmmss".replaceAll("'", "") + " | timestamp";
    private static final Log LOG = LogFactory.getLog(TraceAnalysisTool.class);
    private static final String ENCODING = "UTF-8";
    private final AnalysisController analysisController = new AnalysisController();
    private String[] inputDirs;
    private String outputDir;
    private String outputFnPrefix;
    private Set<Long> selectedTraces;
    private boolean invertTraceIdFilter;
    private boolean ignoreAssumedCalls;
    private boolean shortLabels = true;
    private boolean includeSelfLoops;
    private boolean ignoreInvalidTraces;
    private int maxTraceDurationMillis = 600000;
    private long ignoreExecutionsBeforeTimestamp = Long.parseLong("0");
    private long ignoreExecutionsAfterTimestamp = Long.parseLong("9223372036854775807");
    private CommandLine cmdl;

    private TraceAnalysisTool(boolean useSystemExit) {
        super(useSystemExit);
    }

    public static void main(String[] args) {
        TraceAnalysisTool.mainHelper(args, true);
    }

    public static void mainHelper(String[] args, boolean useSystemExit) {
        new TraceAnalysisTool(useSystemExit).start(args);
    }

    @Override
    protected void addAdditionalOptions(Options options) {
        ArrayList inheritedOptions = new ArrayList();
        inheritedOptions.addAll(options.getOptions());
        for (Object option : Constants.CMDL_OPTIONS.getOptions()) {
            options.addOption((Option)option);
        }
        for (Object option : inheritedOptions) {
            if (Constants.SORTED_OPTION_LIST.contains(option)) continue;
            Constants.SORTED_OPTION_LIST.add((Option)option);
        }
    }

    @Override
    protected boolean readPropertiesFromCommandLine(CommandLine commandLine) {
        this.cmdl = commandLine;
        return this.initFromArgs(commandLine) && this.assertOutputDirExists() && this.assertInputDirsExistsAndAreMonitoringLogs();
    }

    @Override
    protected boolean performTask() {
        this.dumpConfiguration();
        return this.dispatchTasks();
    }

    @Override
    protected HelpFormatter getHelpFormatter() {
        CLIHelpFormatter helpFormatter = new CLIHelpFormatter();
        helpFormatter.setOptionComparator(new OptionComparator());
        return helpFormatter;
    }

    private boolean initFromArgs(CommandLine commandLine) {
        block14: {
            this.inputDirs = commandLine.getOptionValues("inputdirs");
            this.outputDir = commandLine.getOptionValue("outputdir");
            this.outputFnPrefix = this.cmdl.getOptionValue("output-filename-prefix", "");
            if (this.cmdl.hasOption("select-traces") && this.cmdl.hasOption("filter-traces")) {
                LOG.error("Trace Id selection and filtering are mutually exclusive");
                return false;
            }
            if (this.cmdl.hasOption("select-traces") || this.cmdl.hasOption("filter-traces")) {
                this.invertTraceIdFilter = this.cmdl.hasOption("filter-traces");
                Object[] traceIdList = this.cmdl.getOptionValues(this.invertTraceIdFilter ? "filter-traces" : "select-traces");
                this.selectedTraces = new TreeSet<Long>();
                int numSelectedTraces = traceIdList.length;
                try {
                    for (Object idStr : traceIdList) {
                        this.selectedTraces.add(Long.valueOf((String)idStr));
                    }
                    LOG.info(numSelectedTraces + " trace" + (numSelectedTraces > 1 ? "s" : "") + (this.invertTraceIdFilter ? " filtered" : " selected"));
                }
                catch (Exception e) {
                    LOG.error("Failed to parse list of trace IDs: " + Arrays.toString(traceIdList), e);
                    return false;
                }
            }
            this.shortLabels = commandLine.hasOption("short-labels");
            this.includeSelfLoops = commandLine.hasOption("include-self-loops");
            this.ignoreInvalidTraces = commandLine.hasOption("ignore-invalid-traces");
            this.ignoreAssumedCalls = commandLine.hasOption("ignore-assumed-calls");
            String maxTraceDurationStr = commandLine.getOptionValue("max-trace-duration", Integer.toString(this.maxTraceDurationMillis));
            try {
                this.maxTraceDurationMillis = Integer.parseInt(maxTraceDurationStr);
            }
            catch (NumberFormatException exc) {
                LOG.error("Failed to parse int value of property max-trace-duration (must be an integer):" + maxTraceDurationStr, exc);
                return false;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'-'HHmmss", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                long ignoreExecutionsAfterTimestampTemp;
                String ignoreRecordsBeforeTimestampString = commandLine.getOptionValue("ignore-executions-before-date", null);
                String ignoreRecordsAfterTimestampString = commandLine.getOptionValue("ignore-executions-after-date", null);
                if (ignoreRecordsBeforeTimestampString != null) {
                    long ignoreExecutionsBeforeTimestampTemp;
                    try {
                        ignoreExecutionsBeforeTimestampTemp = Long.parseLong(ignoreRecordsBeforeTimestampString);
                        LOG.info("Ignoring records before " + ignoreExecutionsBeforeTimestampTemp);
                    }
                    catch (NumberFormatException ex) {
                        Date ignoreBeforeDate = dateFormat.parse(ignoreRecordsBeforeTimestampString);
                        ignoreExecutionsBeforeTimestampTemp = ignoreBeforeDate.getTime() * 1000000L;
                        LOG.info("Ignoring records before " + dateFormat.format(ignoreBeforeDate) + " (" + ignoreExecutionsBeforeTimestampTemp + ")");
                    }
                    this.ignoreExecutionsBeforeTimestamp = ignoreExecutionsBeforeTimestampTemp;
                }
                if (ignoreRecordsAfterTimestampString == null) break block14;
                try {
                    ignoreExecutionsAfterTimestampTemp = Long.parseLong(ignoreRecordsAfterTimestampString);
                    LOG.info("Ignoring records after " + ignoreExecutionsAfterTimestampTemp);
                }
                catch (NumberFormatException ex) {
                    Date ignoreAfterDate = dateFormat.parse(ignoreRecordsAfterTimestampString);
                    ignoreExecutionsAfterTimestampTemp = ignoreAfterDate.getTime() * 1000000L;
                    LOG.info("Ignoring records after " + dateFormat.format(ignoreAfterDate) + " (" + ignoreExecutionsAfterTimestampTemp + ")");
                }
                this.ignoreExecutionsAfterTimestamp = ignoreExecutionsAfterTimestampTemp;
            }
            catch (ParseException ex) {
                String errorMsg = "Error parsing date/time string. Please use the following pattern: " + DATE_FORMAT_PATTERN_CMD_USAGE_HELP;
                LOG.error(errorMsg, ex);
                return false;
            }
        }
        return true;
    }

    private boolean assertOutputDirExists() {
        if (this.outputDir == null || this.outputDir.isEmpty()) {
            LOG.error("No output directory configured");
            return false;
        }
        File outputDirFile = new File(this.outputDir);
        try {
            if (!outputDirFile.exists()) {
                LOG.error("The specified output directory '" + outputDirFile.getCanonicalPath() + "' does not exist");
                return false;
            }
            if (!outputDirFile.isDirectory()) {
                LOG.error("The specified output directory '" + outputDirFile.getCanonicalPath() + "' is not a directory");
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("Error resolving name of output directory: '" + this.outputDir + "'");
        }
        return true;
    }

    private static void addDecorators(String[] decoratorNames, AbstractDependencyGraphFilter<?> plugin) {
        if (decoratorNames == null) {
            return;
        }
        List<String> decoratorList = Arrays.asList(decoratorNames);
        Iterator<String> decoratorIterator = decoratorList.iterator();
        while (decoratorIterator.hasNext()) {
            String currentDecoratorStr = decoratorIterator.next();
            if ("responseTimes".equals(currentDecoratorStr)) {
                plugin.addDecorator(new ResponseTimeNodeDecorator(TimeUnit.MILLISECONDS));
                continue;
            }
            if ("responseTimes-ns".equals(currentDecoratorStr)) {
                plugin.addDecorator(new ResponseTimeNodeDecorator(TimeUnit.NANOSECONDS));
                continue;
            }
            if ("responseTimes-us".equals(currentDecoratorStr)) {
                plugin.addDecorator(new ResponseTimeNodeDecorator(TimeUnit.MICROSECONDS));
                continue;
            }
            if ("responseTimes-ms".equals(currentDecoratorStr)) {
                plugin.addDecorator(new ResponseTimeNodeDecorator(TimeUnit.MILLISECONDS));
                continue;
            }
            if ("responseTimes-s".equals(currentDecoratorStr)) {
                plugin.addDecorator(new ResponseTimeNodeDecorator(TimeUnit.SECONDS));
                continue;
            }
            if ("responseTimeColoring".equals(currentDecoratorStr)) {
                String thresholdStringStr = decoratorIterator.next();
                try {
                    int threshold = Integer.parseInt(thresholdStringStr);
                    plugin.addDecorator(new ResponseTimeColorNodeDecorator(threshold));
                }
                catch (NumberFormatException exc) {
                    System.err.println("\nFailed to parse int value of property threshold(ms) : " + thresholdStringStr);
                }
                continue;
            }
            LOG.warn("Unknown decoration name '" + currentDecoratorStr + "'.");
            return;
        }
    }

    private boolean assertInputDirsExistsAndAreMonitoringLogs() {
        if (this.inputDirs == null) {
            LOG.error("No input directories configured");
            return false;
        }
        for (String inputDir : this.inputDirs) {
            File inputDirFile = new File(inputDir);
            try {
                if (!inputDirFile.exists()) {
                    LOG.error("The specified input directory '" + inputDirFile.getCanonicalPath() + "' does not exist");
                    return false;
                }
                if (!inputDirFile.isDirectory() && !inputDir.endsWith(".zip")) {
                    LOG.error("The specified input directory '" + inputDirFile.getCanonicalPath() + "' is neither a directory nor a zip file");
                    return false;
                }
                if (!inputDirFile.isDirectory()) continue;
                File[] mapFiles = new File[]{new File(inputDir + File.separatorChar + "kieker.map"), new File(inputDir + File.separatorChar + "tpmon.map")};
                boolean mapFileExists = false;
                for (File potentialMapFile : mapFiles) {
                    if (!potentialMapFile.isFile()) continue;
                    mapFileExists = true;
                    break;
                }
                if (mapFileExists) continue;
                LOG.error("The specified input directory '" + inputDirFile.getCanonicalPath() + "' is not a kieker log directory");
                return false;
            }
            catch (IOException e) {
                LOG.error("Error resolving name of input directory: '" + inputDir + "'");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchTasks() {
        boolean retVal = true;
        int numRequestedTasks = 0;
        SystemModelRepository systemEntityFactory = new SystemModelRepository(new Configuration(), this.analysisController);
        TraceReconstructionFilter mtReconstrFilter = null;
        AbstractTraceProcessingFilter eventRecordTraceCounter = null;
        EventRecordTraceReconstructionFilter eventTraceReconstructionFilter = null;
        AbstractTraceProcessingFilter traceEvents2ExecutionAndMessageTraceFilter = null;
        try {
            Configuration conf = new Configuration(null);
            conf.setProperty("inputDirs", Configuration.toProperty(this.inputDirs));
            conf.setProperty("ignoreUnknownRecordTypes", Boolean.TRUE.toString());
            FSReader reader = new FSReader(conf, this.analysisController);
            StringBufferFilter stringBufferFilter = new StringBufferFilter(new Configuration(), this.analysisController);
            this.analysisController.connect(reader, "monitoringRecords", stringBufferFilter, "received-events");
            Configuration configTimestampFilter = new Configuration();
            configTimestampFilter.setProperty("ignoreBeforeTimestamp", Long.toString(this.ignoreExecutionsBeforeTimestamp));
            configTimestampFilter.setProperty("ignoreAfterTimestamp", Long.toString(this.ignoreExecutionsAfterTimestamp));
            TimestampFilter timestampFilter = new TimestampFilter(configTimestampFilter, this.analysisController);
            this.analysisController.connect(stringBufferFilter, "relayed-events", timestampFilter, "monitoringRecordsExecution");
            this.analysisController.connect(stringBufferFilter, "relayed-events", timestampFilter, "monitoringRecordsFlow");
            Configuration configTraceIdFilterFlow = new Configuration();
            if (this.selectedTraces == null) {
                configTraceIdFilterFlow.setProperty("acceptAllTraces", Boolean.TRUE.toString());
            } else {
                configTraceIdFilterFlow.setProperty("acceptAllTraces", Boolean.FALSE.toString());
                configTraceIdFilterFlow.setProperty("selectedTraceIds", Configuration.toProperty(this.selectedTraces.toArray(new Long[this.selectedTraces.size()])));
            }
            TraceIdFilter traceIdFilter = new TraceIdFilter(configTraceIdFilterFlow, this.analysisController);
            this.analysisController.connect(timestampFilter, "recordsWithinTimePeriod", traceIdFilter, "monitoringRecordsCombined");
            Configuration execRecTransformerConfig = new Configuration();
            execRecTransformerConfig.setProperty("name-hiddenAndNeverExportedProperty", "Execution record transformation");
            ExecutionRecordTransformationFilter execRecTransformer = new ExecutionRecordTransformationFilter(execRecTransformerConfig, this.analysisController);
            if (this.invertTraceIdFilter) {
                this.analysisController.connect(traceIdFilter, "recordsNotMatchingId", execRecTransformer, "operationExecutionRecords");
            } else {
                this.analysisController.connect(traceIdFilter, "recordsMatchingId", execRecTransformer, "operationExecutionRecords");
            }
            this.analysisController.connect(execRecTransformer, "systemModelRepository", systemEntityFactory);
            Configuration mtReconstrFilterConfig = new Configuration();
            mtReconstrFilterConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (execution records -> execution traces)");
            mtReconstrFilterConfig.setProperty("timeunit", TimeUnit.MILLISECONDS.name());
            mtReconstrFilterConfig.setProperty("maxTraceDuration", Integer.toString(this.maxTraceDurationMillis));
            mtReconstrFilterConfig.setProperty("ignoreInvalidTraces", Boolean.toString(this.ignoreInvalidTraces));
            mtReconstrFilter = new TraceReconstructionFilter(mtReconstrFilterConfig, this.analysisController);
            this.analysisController.connect(mtReconstrFilter, "systemModelRepository", systemEntityFactory);
            this.analysisController.connect(execRecTransformer, "transformedExecutions", mtReconstrFilter, "executions");
            Configuration configurationEventRecordTraceGenerationFilter = new Configuration();
            configurationEventRecordTraceGenerationFilter.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (trace event records -> event record traces)");
            configurationEventRecordTraceGenerationFilter.setProperty("timeunit", TimeUnit.MILLISECONDS.name());
            configurationEventRecordTraceGenerationFilter.setProperty("maxTraceDuration", Long.toString(this.maxTraceDurationMillis));
            eventTraceReconstructionFilter = new EventRecordTraceReconstructionFilter(configurationEventRecordTraceGenerationFilter, this.analysisController);
            if (this.invertTraceIdFilter) {
                this.analysisController.connect(traceIdFilter, "recordsNotMatchingId", eventTraceReconstructionFilter, "traceRecords");
            } else {
                this.analysisController.connect(traceIdFilter, "recordsMatchingId", eventTraceReconstructionFilter, "traceRecords");
            }
            Configuration configurationEventRecordTraceCounter = new Configuration();
            configurationEventRecordTraceCounter.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (event records -> event record traces)");
            configurationEventRecordTraceCounter.setProperty("logInvalidTraces", Boolean.toString(!this.ignoreInvalidTraces));
            eventRecordTraceCounter = new EventRecordTraceCounter(configurationEventRecordTraceCounter, this.analysisController);
            this.analysisController.connect(eventTraceReconstructionFilter, "validTraces", eventRecordTraceCounter, "validEventRecordTraces");
            this.analysisController.connect(eventTraceReconstructionFilter, "invalidTraces", eventRecordTraceCounter, "invalidEventRecordTraces");
            Configuration configurationEventTrace2ExecutionTraceFilter = new Configuration();
            configurationEventTrace2ExecutionTraceFilter.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (event record traces -> execution traces)");
            configurationEventTrace2ExecutionTraceFilter.setProperty("ignoreAssumed", Boolean.toString(this.ignoreAssumedCalls));
            traceEvents2ExecutionAndMessageTraceFilter = new TraceEventRecords2ExecutionAndMessageTraceFilter(configurationEventTrace2ExecutionTraceFilter, this.analysisController);
            this.analysisController.connect(eventTraceReconstructionFilter, "validTraces", traceEvents2ExecutionAndMessageTraceFilter, "traceEvents");
            this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "systemModelRepository", systemEntityFactory);
            ArrayList<AbstractTraceProcessingFilter> allTraceProcessingComponents = new ArrayList<AbstractTraceProcessingFilter>();
            ArrayList allGraphProducers = new ArrayList();
            Configuration traceAllocationEquivClassFilterConfig = new Configuration();
            traceAllocationEquivClassFilterConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace equivalence class filter (deployment mode)");
            traceAllocationEquivClassFilterConfig.setProperty("equivalenceMode", TraceEquivalenceClassFilter.TraceEquivalenceClassModes.ALLOCATION.toString());
            TraceEquivalenceClassFilter traceAllocationEquivClassFilter = null;
            if (this.cmdl.hasOption("print-Deployment-Equivalence-Classes")) {
                traceAllocationEquivClassFilter = new TraceEquivalenceClassFilter(traceAllocationEquivClassFilterConfig, this.analysisController);
                this.analysisController.connect(traceAllocationEquivClassFilter, "systemModelRepository", systemEntityFactory);
                this.analysisController.connect(mtReconstrFilter, "executionTraces", traceAllocationEquivClassFilter, "executionTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "executionTrace", traceAllocationEquivClassFilter, "executionTraces");
                allTraceProcessingComponents.add(traceAllocationEquivClassFilter);
            }
            Configuration traceAssemblyEquivClassFilterConfig = new Configuration();
            traceAssemblyEquivClassFilterConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace equivalence class filter (assembly mode)");
            traceAssemblyEquivClassFilterConfig.setProperty("equivalenceMode", TraceEquivalenceClassFilter.TraceEquivalenceClassModes.ASSEMBLY.toString());
            TraceEquivalenceClassFilter traceAssemblyEquivClassFilter = null;
            if (this.cmdl.hasOption("print-Assembly-Equivalence-Classes")) {
                traceAssemblyEquivClassFilter = new TraceEquivalenceClassFilter(traceAssemblyEquivClassFilterConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "executionTraces", traceAssemblyEquivClassFilter, "executionTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "executionTrace", traceAssemblyEquivClassFilter, "executionTraces");
                this.analysisController.connect(traceAssemblyEquivClassFilter, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(traceAssemblyEquivClassFilter);
            }
            MessageTraceWriterFilter componentPrintMsgTrace = null;
            if (this.cmdl.hasOption("print-Message-Traces")) {
                ++numRequestedTasks;
                Configuration componentPrintMsgTraceConfig = new Configuration();
                componentPrintMsgTraceConfig.setProperty("name-hiddenAndNeverExportedProperty", "Print message traces");
                componentPrintMsgTraceConfig.setProperty("outputFn", new File(this.outputDir + File.separator + this.outputFnPrefix + "messageTraces" + ".txt").getCanonicalPath());
                componentPrintMsgTrace = new MessageTraceWriterFilter(componentPrintMsgTraceConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPrintMsgTrace, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPrintMsgTrace, "messageTraces");
                this.analysisController.connect(componentPrintMsgTrace, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPrintMsgTrace);
            }
            ExecutionTraceWriterFilter componentPrintExecTrace = null;
            if (this.cmdl.hasOption("print-Execution-Traces")) {
                ++numRequestedTasks;
                Configuration componentPrintExecTraceConfig = new Configuration();
                componentPrintExecTraceConfig.setProperty("name-hiddenAndNeverExportedProperty", "Print execution traces");
                componentPrintExecTraceConfig.setProperty("outputFn", new File(this.outputDir + File.separator + this.outputFnPrefix + "executionTraces" + ".txt").getCanonicalPath());
                componentPrintExecTrace = new ExecutionTraceWriterFilter(componentPrintExecTraceConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "executionTraces", componentPrintExecTrace, "executionTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "executionTrace", componentPrintExecTrace, "executionTraces");
                this.analysisController.connect(componentPrintExecTrace, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPrintExecTrace);
            }
            InvalidExecutionTraceWriterFilter componentPrintInvalidTrace = null;
            if (this.cmdl.hasOption("print-invalid-Execution-Traces")) {
                ++numRequestedTasks;
                Configuration componentPrintInvalidTraceConfig = new Configuration();
                componentPrintInvalidTraceConfig.setProperty("name-hiddenAndNeverExportedProperty", "Print invalid execution traces");
                componentPrintInvalidTraceConfig.setProperty("outputFn", new File(this.outputDir + File.separator + this.outputFnPrefix + "invalidTraceArtifacts" + ".txt").getCanonicalPath());
                componentPrintInvalidTrace = new InvalidExecutionTraceWriterFilter(componentPrintInvalidTraceConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "invalidExecutionTraces", componentPrintInvalidTrace, "invalidExecutionTraces");
                this.analysisController.connect(componentPrintInvalidTrace, "systemModelRepository", systemEntityFactory);
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "invalidTrace", componentPrintInvalidTrace, "invalidExecutionTraces");
                allTraceProcessingComponents.add(componentPrintInvalidTrace);
            }
            SequenceDiagramFilter componentPlotAllocationSeqDiagr = null;
            if (retVal && this.cmdl.hasOption("plot-Deployment-Sequence-Diagrams")) {
                ++numRequestedTasks;
                Configuration componentPlotAllocationSeqDiagrConfig = new Configuration();
                componentPlotAllocationSeqDiagrConfig.setProperty("name-hiddenAndNeverExportedProperty", "Sequence diagrams (deployment level)");
                componentPlotAllocationSeqDiagrConfig.setProperty("filename", this.outputDir + File.separator + this.outputFnPrefix + "deploymentSequenceDiagram");
                componentPlotAllocationSeqDiagrConfig.setProperty("SDMode", SequenceDiagramFilter.SDModes.ALLOCATION.toString());
                componentPlotAllocationSeqDiagrConfig.setProperty("shortLabels", Boolean.toString(this.shortLabels));
                componentPlotAllocationSeqDiagr = new SequenceDiagramFilter(componentPlotAllocationSeqDiagrConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAllocationSeqDiagr, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAllocationSeqDiagr, "messageTraces");
                this.analysisController.connect(componentPlotAllocationSeqDiagr, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAllocationSeqDiagr);
            }
            SequenceDiagramFilter componentPlotAssemblySeqDiagr = null;
            if (retVal && this.cmdl.hasOption("plot-Assembly-Sequence-Diagrams")) {
                ++numRequestedTasks;
                Configuration componentPlotAssemblySeqDiagrConfig = new Configuration();
                componentPlotAssemblySeqDiagrConfig.setProperty("name-hiddenAndNeverExportedProperty", "Sequence diagrams (assembly level)");
                componentPlotAssemblySeqDiagrConfig.setProperty("filename", this.outputDir + File.separator + this.outputFnPrefix + "assemblySequenceDiagram");
                componentPlotAssemblySeqDiagrConfig.setProperty("SDMode", SequenceDiagramFilter.SDModes.ASSEMBLY.toString());
                componentPlotAssemblySeqDiagrConfig.setProperty("shortLabels", Boolean.toString(this.shortLabels));
                componentPlotAssemblySeqDiagr = new SequenceDiagramFilter(componentPlotAssemblySeqDiagrConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblySeqDiagr, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblySeqDiagr, "messageTraces");
                this.analysisController.connect(componentPlotAssemblySeqDiagr, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAssemblySeqDiagr);
            }
            ComponentDependencyGraphAllocationFilter componentPlotAllocationComponentDepGraph = null;
            if (retVal && this.cmdl.hasOption("plot-Deployment-Component-Dependency-Graph")) {
                ++numRequestedTasks;
                Configuration configuration = new Configuration();
                componentPlotAllocationComponentDepGraph = new ComponentDependencyGraphAllocationFilter(configuration, this.analysisController);
                String[] nodeDecorations = this.cmdl.getOptionValues("plot-Deployment-Component-Dependency-Graph");
                TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAllocationComponentDepGraph);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAllocationComponentDepGraph, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAllocationComponentDepGraph, "messageTraces");
                this.analysisController.connect(componentPlotAllocationComponentDepGraph, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAllocationComponentDepGraph);
                allGraphProducers.add(componentPlotAllocationComponentDepGraph);
            }
            ComponentDependencyGraphAssemblyFilter componentPlotAssemblyComponentDepGraph = null;
            if (retVal && this.cmdl.hasOption("plot-Assembly-Component-Dependency-Graph")) {
                ++numRequestedTasks;
                Configuration configuration = new Configuration();
                componentPlotAssemblyComponentDepGraph = new ComponentDependencyGraphAssemblyFilter(configuration, this.analysisController);
                String[] nodeDecorations = this.cmdl.getOptionValues("plot-Assembly-Component-Dependency-Graph");
                TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAssemblyComponentDepGraph);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblyComponentDepGraph, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblyComponentDepGraph, "messageTraces");
                this.analysisController.connect(componentPlotAssemblyComponentDepGraph, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAssemblyComponentDepGraph);
                allGraphProducers.add(componentPlotAssemblyComponentDepGraph);
            }
            ContainerDependencyGraphFilter componentPlotContainerDepGraph = null;
            if (retVal && this.cmdl.hasOption("plot-Container-Dependency-Graph")) {
                ++numRequestedTasks;
                Configuration configuration = new Configuration();
                componentPlotContainerDepGraph = new ContainerDependencyGraphFilter(configuration, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotContainerDepGraph, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotContainerDepGraph, "messageTraces");
                this.analysisController.connect(componentPlotContainerDepGraph, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotContainerDepGraph);
                allGraphProducers.add(componentPlotContainerDepGraph);
            }
            OperationDependencyGraphAllocationFilter componentPlotAllocationOperationDepGraph = null;
            if (retVal && this.cmdl.hasOption("plot-Deployment-Operation-Dependency-Graph")) {
                ++numRequestedTasks;
                Configuration configuration = new Configuration();
                componentPlotAllocationOperationDepGraph = new OperationDependencyGraphAllocationFilter(configuration, this.analysisController);
                String[] nodeDecorations = this.cmdl.getOptionValues("plot-Deployment-Operation-Dependency-Graph");
                TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAllocationOperationDepGraph);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAllocationOperationDepGraph, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAllocationOperationDepGraph, "messageTraces");
                this.analysisController.connect(componentPlotAllocationOperationDepGraph, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAllocationOperationDepGraph);
                allGraphProducers.add(componentPlotAllocationOperationDepGraph);
            }
            OperationDependencyGraphAssemblyFilter componentPlotAssemblyOperationDepGraph = null;
            if (retVal && this.cmdl.hasOption("plot-Assembly-Operation-Dependency-Graph")) {
                ++numRequestedTasks;
                Configuration configuration = new Configuration();
                componentPlotAssemblyOperationDepGraph = new OperationDependencyGraphAssemblyFilter(configuration, this.analysisController);
                String[] nodeDecorations = this.cmdl.getOptionValues("plot-Assembly-Operation-Dependency-Graph");
                TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAssemblyOperationDepGraph);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblyOperationDepGraph, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblyOperationDepGraph, "messageTraces");
                this.analysisController.connect(componentPlotAssemblyOperationDepGraph, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAssemblyOperationDepGraph);
                allGraphProducers.add(componentPlotAssemblyOperationDepGraph);
            }
            TraceCallTreeFilter componentPlotTraceCallTrees = null;
            if (retVal && this.cmdl.hasOption("plot-Call-Trees")) {
                ++numRequestedTasks;
                Configuration componentPlotTraceCallTreesConfig = new Configuration();
                componentPlotTraceCallTreesConfig.setProperty("dotOutputFn", new File(this.outputDir + File.separator + this.outputFnPrefix + "callTree").getCanonicalPath());
                componentPlotTraceCallTreesConfig.setProperty("shortLabels", Boolean.toString(this.shortLabels));
                componentPlotTraceCallTreesConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace call trees");
                componentPlotTraceCallTrees = new TraceCallTreeFilter(componentPlotTraceCallTreesConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotTraceCallTrees, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotTraceCallTrees, "messageTraces");
                this.analysisController.connect(componentPlotTraceCallTrees, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotTraceCallTrees);
            }
            AggregatedAllocationComponentOperationCallTreeFilter componentPlotAggregatedCallTree = null;
            if (retVal && this.cmdl.hasOption("plot-Aggregated-Deployment-Call-Tree")) {
                ++numRequestedTasks;
                Configuration componentPlotAggregatedCallTreeConfig = new Configuration();
                componentPlotAggregatedCallTreeConfig.setProperty("name-hiddenAndNeverExportedProperty", "Aggregated call tree (deployment level)");
                componentPlotAggregatedCallTreeConfig.setProperty("includeWeights", Boolean.toString(true));
                componentPlotAggregatedCallTreeConfig.setProperty("shortLabels", Boolean.toString(this.shortLabels));
                componentPlotAggregatedCallTreeConfig.setProperty("dotOutputFn", this.outputDir + File.separator + this.outputFnPrefix + "aggregatedDeploymentCallTree" + ".dot");
                componentPlotAggregatedCallTree = new AggregatedAllocationComponentOperationCallTreeFilter(componentPlotAggregatedCallTreeConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAggregatedCallTree, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAggregatedCallTree, "messageTraces");
                this.analysisController.connect(componentPlotAggregatedCallTree, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAggregatedCallTree);
            }
            AggregatedAssemblyComponentOperationCallTreeFilter componentPlotAssemblyCallTree = null;
            if (retVal && this.cmdl.hasOption("plot-Aggregated-Assembly-Call-Tree")) {
                ++numRequestedTasks;
                Configuration componentPlotAssemblyCallTreeConfig = new Configuration();
                componentPlotAssemblyCallTreeConfig.setProperty("name-hiddenAndNeverExportedProperty", "Aggregated call tree (assembly level)");
                componentPlotAssemblyCallTreeConfig.setProperty("includeWeights", Boolean.toString(true));
                componentPlotAssemblyCallTreeConfig.setProperty("shortLabels", Boolean.toString(this.shortLabels));
                componentPlotAssemblyCallTreeConfig.setProperty("dotOutputFn", this.outputDir + File.separator + this.outputFnPrefix + "aggregatedAssemblyCallTree" + ".dot");
                componentPlotAssemblyCallTree = new AggregatedAssemblyComponentOperationCallTreeFilter(componentPlotAssemblyCallTreeConfig, this.analysisController);
                this.analysisController.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblyCallTree, "messageTraces");
                this.analysisController.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblyCallTree, "messageTraces");
                this.analysisController.connect(componentPlotAssemblyCallTree, "systemModelRepository", systemEntityFactory);
                allTraceProcessingComponents.add(componentPlotAssemblyCallTree);
            }
            if (retVal && this.cmdl.hasOption("print-Deployment-Equivalence-Classes")) {
                ++numRequestedTasks;
            }
            if (this.cmdl.hasOption("print-System-Model")) {
                ++numRequestedTasks;
            }
            this.attachGraphProcessors(allGraphProducers, this.analysisController, this.cmdl);
            if (numRequestedTasks == 0) {
                LOG.error("No task requested");
                LOG.info("Use the option `--help` for usage information");
                boolean componentPlotAssemblyCallTreeConfig = false;
                return componentPlotAssemblyCallTreeConfig;
            }
            if (retVal) {
                String systemEntitiesHtmlFn = this.outputDir + File.separator + this.outputFnPrefix + "system-entities.html";
                Configuration systemModel2FileFilterConfig = new Configuration();
                systemModel2FileFilterConfig.setProperty("outputFnHtml", systemEntitiesHtmlFn);
                SystemModel2FileFilter systemModel2FileFilter = new SystemModel2FileFilter(systemModel2FileFilterConfig, this.analysisController);
                this.analysisController.connect(systemModel2FileFilter, "systemModelRepository", systemEntityFactory);
            }
            int numErrorCount = 0;
            try {
                this.analysisController.run();
                if (this.analysisController.getState() != AnalysisController.STATE.TERMINATED) {
                    retVal = false;
                    LOG.error("Analysis instance terminated in state other than" + (Object)((Object)AnalysisController.STATE.TERMINATED) + ":" + (Object)((Object)this.analysisController.getState()));
                }
            }
            finally {
                for (AbstractTraceProcessingFilter c : allTraceProcessingComponents) {
                    numErrorCount += c.getErrorCount();
                    c.printStatusMessage();
                }
                String kaxOutputFn = this.outputDir + File.separator + this.outputFnPrefix + "traceAnalysis.kax";
                File kaxOutputFile = new File(kaxOutputFn);
                try {
                    this.analysisController.saveToFile(kaxOutputFile);
                    LOG.info("Saved analysis configuration to file '" + kaxOutputFile.getCanonicalPath() + "'");
                }
                catch (IOException ex) {
                    LOG.error("Failed to save analysis configuration to file '" + kaxOutputFile.getCanonicalPath() + "'");
                }
            }
            if (!this.ignoreInvalidTraces && numErrorCount > 0) {
                throw new Exception(numErrorCount + " errors occured in trace processing components");
            }
            if (retVal && this.cmdl.hasOption("print-Deployment-Equivalence-Classes")) {
                retVal = this.writeTraceEquivalenceReport(this.outputDir + File.separator + this.outputFnPrefix + "traceDeploymentEquivClasses" + ".txt", traceAllocationEquivClassFilter);
            }
            if (retVal && this.cmdl.hasOption("print-Assembly-Equivalence-Classes")) {
                retVal = this.writeTraceEquivalenceReport(this.outputDir + File.separator + this.outputFnPrefix + "traceAssemblyEquivClasses" + ".txt", traceAssemblyEquivClassFilter);
            }
        }
        catch (Exception ex) {
            LOG.error("An error occured", ex);
            retVal = false;
        }
        finally {
            if (numRequestedTasks > 0) {
                if (mtReconstrFilter != null) {
                    mtReconstrFilter.printStatusMessage();
                }
                if (eventRecordTraceCounter != null) {
                    eventRecordTraceCounter.printStatusMessage();
                }
                if (traceEvents2ExecutionAndMessageTraceFilter != null) {
                    traceEvents2ExecutionAndMessageTraceFilter.printStatusMessage();
                }
            }
        }
        return retVal;
    }

    private void dumpConfiguration() {
        LOG.debug("#");
        LOG.debug("# Configuration");
        for (Option o : Constants.SORTED_OPTION_LIST) {
            String longOpt = o.getLongOpt();
            String val = "<null>";
            if (longOpt.equals("inputdirs")) {
                val = Constants.stringArrToStringList(this.inputDirs);
            } else if (longOpt.equals("outputdir")) {
                val = this.outputDir;
            } else if (longOpt.equals("output-filename-prefix")) {
                val = this.outputFnPrefix;
            } else if (longOpt.equals("print-Deployment-Equivalence-Classes") || longOpt.equals("print-Assembly-Equivalence-Classes") || longOpt.equals("plot-Deployment-Sequence-Diagrams") || longOpt.equals("plot-Assembly-Sequence-Diagrams") || longOpt.equals("plot-Deployment-Component-Dependency-Graph") || longOpt.equals("plot-Assembly-Component-Dependency-Graph") || longOpt.equals("plot-Container-Dependency-Graph") || longOpt.equals("plot-Deployment-Operation-Dependency-Graph") || longOpt.equals("plot-Assembly-Operation-Dependency-Graph") || longOpt.equals("plot-Aggregated-Deployment-Call-Tree") || longOpt.equals("plot-Aggregated-Assembly-Call-Tree") || longOpt.equals("plot-Call-Trees") || longOpt.equals("print-Execution-Traces") || longOpt.equals("print-invalid-Execution-Traces") || longOpt.equals("print-Message-Traces") || longOpt.equals("print-System-Model") || longOpt.equals("debug") || longOpt.equals("verbose") || longOpt.equals("help")) {
                val = this.cmdl.hasOption(longOpt) ? "true" : "false";
            } else if (longOpt.equals("select-traces")) {
                val = this.selectedTraces != null ? this.selectedTraces.toString() : "<select all>";
            } else if (longOpt.equals("filter-traces")) {
                val = this.selectedTraces != null ? this.selectedTraces.toString() : "<filter none>";
            } else if (longOpt.equals("short-labels")) {
                val = this.shortLabels ? "true" : "false";
            } else if (longOpt.equals("include-self-loops")) {
                val = this.includeSelfLoops ? "true" : "false";
            } else if (longOpt.equals("ignore-assumed-calls")) {
                val = this.ignoreAssumedCalls ? "true" : "false";
            } else if (longOpt.equals("ignore-invalid-traces")) {
                val = this.ignoreInvalidTraces ? "true" : "false";
            } else if (longOpt.equals("max-trace-duration")) {
                val = this.maxTraceDurationMillis + " ms";
            } else if (longOpt.equals("ignore-executions-before-date")) {
                val = LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.ignoreExecutionsBeforeTimestamp) + " (" + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(this.ignoreExecutionsBeforeTimestamp) + ")";
            } else if (longOpt.equals("ignore-executions-after-date")) {
                val = LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.ignoreExecutionsAfterTimestamp) + " (" + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(this.ignoreExecutionsAfterTimestamp) + ")";
            } else if ("traceColoring".equals(longOpt)) {
                val = this.cmdl.getOptionValue("traceColoring");
                if (val == null) {
                    val = "";
                }
            } else if ("addDescriptions".equals(longOpt)) {
                val = this.cmdl.getOptionValue("addDescriptions");
                if (val == null) {
                    val = "";
                }
            } else {
                val = Arrays.toString(this.cmdl.getOptionValues(longOpt));
                LOG.warn("Unformatted configuration output for option " + longOpt);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("--" + longOpt + ": " + val);
        }
    }

    private <P extends AbstractPlugin> void attachGraphWriter(P plugin, AbstractGraphProducingFilter<?> producer, AnalysisController controller) throws IllegalStateException, AnalysisConfigurationException {
        Configuration configuration = new Configuration();
        configuration.setProperty("outputPath", this.outputDir + File.separator + this.outputFnPrefix);
        configuration.setProperty("includeWeights", String.valueOf(true));
        configuration.setProperty("shortLabels", String.valueOf(this.shortLabels));
        configuration.setProperty("selfLoops", String.valueOf(this.includeSelfLoops));
        configuration.setProperty("name-hiddenAndNeverExportedProperty", producer.getConfigurationName());
        GraphWriterPlugin graphWriter = new GraphWriterPlugin(configuration, controller);
        controller.connect(plugin, ((IGraphOutputtingFilter)((Object)plugin)).getGraphOutputPortName(), graphWriter, "inputGraph");
    }

    private static <P extends AbstractPlugin> void connectGraphFilters(P predecessor, AbstractGraphFilter<?, ?, ?, ?> filter, AnalysisController controller) throws IllegalStateException, AnalysisConfigurationException {
        controller.connect(predecessor, ((IGraphOutputtingFilter)((Object)predecessor)).getGraphOutputPortName(), filter, filter.getGraphInputPortName());
    }

    private static <P extends AbstractPlugin> TraceColoringFilter<?, ?> createTraceColoringFilter(P predecessor, String coloringFileName, AnalysisController controller) throws IOException, IllegalStateException, AnalysisConfigurationException {
        TraceColorRepository colorRepository = TraceColorRepository.createFromFile(coloringFileName, controller);
        TraceColoringFilter coloringFilter = new TraceColoringFilter(new Configuration(), controller);
        TraceAnalysisTool.connectGraphFilters(predecessor, coloringFilter, controller);
        controller.connect(coloringFilter, "colorRepository", colorRepository);
        return coloringFilter;
    }

    private static <P extends AbstractPlugin> DescriptionDecoratorFilter<?, ?, ?> createDescriptionDecoratorFilter(P predecessor, String descriptionsFileName, AnalysisController controller) throws IOException, IllegalStateException, AnalysisConfigurationException {
        DescriptionRepository descriptionRepository = DescriptionRepository.createFromFile(descriptionsFileName, controller);
        DescriptionDecoratorFilter descriptionFilter = new DescriptionDecoratorFilter(new Configuration(), controller);
        TraceAnalysisTool.connectGraphFilters(predecessor, descriptionFilter, controller);
        controller.connect(descriptionFilter, "descriptionRepository", descriptionRepository);
        return descriptionFilter;
    }

    private void attachGraphProcessors(List<AbstractGraphProducingFilter<?>> graphProducers, AnalysisController controller, CommandLine commandLine) throws IllegalStateException, AnalysisConfigurationException, IOException {
        for (AbstractGraphProducingFilter<?> producer : graphProducers) {
            AbstractGraphFilter lastFilter = null;
            if (commandLine.hasOption("traceColoring")) {
                String coloringFileName = commandLine.getOptionValue("traceColoring");
                lastFilter = TraceAnalysisTool.createTraceColoringFilter(producer, coloringFileName, controller);
            }
            if (commandLine.hasOption("addDescriptions")) {
                String descriptionsFileName = commandLine.getOptionValue("addDescriptions");
                lastFilter = lastFilter != null ? TraceAnalysisTool.createDescriptionDecoratorFilter(lastFilter, descriptionsFileName, controller) : TraceAnalysisTool.createDescriptionDecoratorFilter(producer, descriptionsFileName, controller);
            }
            if (lastFilter != null) {
                this.attachGraphWriter(lastFilter, producer, controller);
                continue;
            }
            this.attachGraphWriter(producer, producer, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeTraceEquivalenceReport(String outputFnPrefixL, TraceEquivalenceClassFilter traceEquivFilter) throws IOException {
        boolean retVal = true;
        String outputFn = new File(outputFnPrefixL).getCanonicalPath();
        PrintStream ps = null;
        try {
            ps = new PrintStream((OutputStream)new FileOutputStream(outputFn), false, ENCODING);
            int numClasses = 0;
            ConcurrentMap<ExecutionTrace, Integer> classMap = traceEquivFilter.getEquivalenceClassMap();
            for (Map.Entry e : classMap.entrySet()) {
                ExecutionTrace t = (ExecutionTrace)e.getKey();
                ps.println("Class " + numClasses++ + " ; cardinality: " + e.getValue() + "; # executions: " + t.getLength() + "; representative: " + t.getTraceId() + "; max. stack depth: " + t.getMaxEss());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("");
                LOG.debug("#");
                LOG.debug("# Plugin: Trace equivalence report");
                LOG.debug("Wrote " + numClasses + " equivalence class" + (numClasses > 1 ? "es" : "") + " to file '" + outputFn + "'");
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found", e);
            retVal = false;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return retVal;
    }

    private static class OptionComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Object o1, Object o2) {
            int posO2;
            if (o1 == o2) {
                return 0;
            }
            int posO1 = Constants.SORTED_OPTION_LIST.indexOf(o1);
            if (posO1 < (posO2 = Constants.SORTED_OPTION_LIST.indexOf(o2))) {
                return -1;
            }
            if (posO1 > posO2) {
                return 1;
            }
            return 0;
        }
    }
}

