/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.record;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class NamedTSPoint
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 20;
    private static final long serialVersionUID = 2928953478026943314L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Double.TYPE, String.class};
    private final long timestamp;
    private final double value;
    private final String name;

    public NamedTSPoint(long timestamp, double value, String name) {
        this.timestamp = timestamp;
        this.value = value;
        this.name = name == null ? "" : name;
    }

    public NamedTSPoint(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.value = (Double)values[1];
        this.name = (String)values[2];
    }

    protected NamedTSPoint(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.timestamp = (Long)values[0];
        this.value = (Double)values[1];
        this.name = (String)values[2];
    }

    public NamedTSPoint(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.timestamp = buffer.getLong();
        this.value = buffer.getDouble();
        this.name = stringRegistry.get(buffer.getInt());
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getValue(), this.getName()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putDouble(this.getValue());
        buffer.putInt(stringRegistry.get(this.getName()));
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 20;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final double getValue() {
        return this.value;
    }

    public final String getName() {
        return this.name;
    }
}

