/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.model.NamedDoubleTimeSeriesPoint;
import kieker.tools.opad.record.AggregationWindow;
import kieker.tools.tslib.AggregationMethod;
import kieker.tools.util.AggregationVariableSet;

@Plugin(name="Variate TimeSeriesPoint Aggregator", outputPorts={@OutputPort(eventTypes={NamedDoubleTimeSeriesPoint.class}, name="aggregatedTSPoint"), @OutputPort(eventTypes={AggregationWindow.class}, name="aggregationWindow")}, configuration={@Property(name="aggregationMethod", defaultValue="MEAN"), @Property(name="aggregationSpan", defaultValue="1000"), @Property(name="timeUnit", defaultValue="MILLISECONDS")})
public class TimeSeriesPointAggregatorFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_TSPOINT = "tspoint";
    public static final String OUTPUT_PORT_NAME_AGGREGATED_TSPOINT = "aggregatedTSPoint";
    public static final String OUTPUT_PORT_NAME_AGGREGATION_WINDOW = "aggregationWindow";
    public static final String CONFIG_PROPERTY_NAME_AGGREGATION_METHOD = "aggregationMethod";
    public static final String CONFIG_PROPERTY_NAME_AGGREGATION_SPAN = "aggregationSpan";
    public static final String CONFIG_PROPERTY_NAME_AGGREGATION_TIMEUNIT = "timeUnit";
    private final ConcurrentHashMap<String, AggregationVariableSet> aggregationVariables;
    private final long aggregationSpan;
    private final TimeUnit timeunit;
    private final AggregationMethod aggregationMethod;
    private AggregationWindow recentWindow = new AggregationWindow(0L, 0L);

    public TimeSeriesPointAggregatorFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        AggregationMethod configAggregationMethod;
        TimeUnit configTimeUnit;
        this.aggregationVariables = new ConcurrentHashMap();
        this.timeunit = this.recordsTimeUnitFromProjectContext;
        String configTimeunitProperty = configuration.getStringProperty(CONFIG_PROPERTY_NAME_AGGREGATION_TIMEUNIT);
        try {
            configTimeUnit = TimeUnit.valueOf(configTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            configTimeUnit = this.timeunit;
            this.log.warn(configTimeunitProperty + " is no valid TimeUnit! Using inherited value of " + configTimeUnit.name() + " instead.");
        }
        try {
            configAggregationMethod = AggregationMethod.valueOf(configuration.getStringProperty(CONFIG_PROPERTY_NAME_AGGREGATION_METHOD));
        }
        catch (IllegalArgumentException ex) {
            configAggregationMethod = AggregationMethod.valueOf("MEAN");
        }
        this.aggregationMethod = configAggregationMethod;
        this.aggregationSpan = this.timeunit.convert(configuration.getIntProperty(CONFIG_PROPERTY_NAME_AGGREGATION_SPAN), configTimeUnit);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_AGGREGATION_SPAN, Long.toString(this.aggregationSpan));
        configuration.setProperty(CONFIG_PROPERTY_NAME_AGGREGATION_TIMEUNIT, this.timeunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_AGGREGATION_METHOD, this.aggregationMethod.name());
        return configuration;
    }

    @InputPort(eventTypes={NamedDoubleTimeSeriesPoint.class}, name="tspoint")
    public void inputTSPoint(NamedDoubleTimeSeriesPoint input) {
        if (this.checkInitialization(input.getName())) {
            this.processInput(input, input.getTime(), input.getName());
        } else {
            this.aggregationVariables.put(input.getName(), new AggregationVariableSet());
            this.processInput(input, input.getTime(), input.getName());
        }
    }

    private boolean checkInitialization(String name) {
        return this.aggregationVariables.containsKey(name);
    }

    private void processInput(NamedDoubleTimeSeriesPoint input, long currentTime, String appname) {
        AggregationVariableSet variables = this.aggregationVariables.get(appname);
        long startOfTimestampsInterval = this.computeFirstTimestampInInterval(currentTime, variables);
        long endOfTimestampsInterval = this.computeLastTimestampInInterval(currentTime, variables);
        if (this.recentWindow.getWindowEnd() != endOfTimestampsInterval) {
            this.recentWindow = new AggregationWindow(startOfTimestampsInterval, endOfTimestampsInterval);
            super.deliver(OUTPUT_PORT_NAME_AGGREGATION_WINDOW, this.recentWindow);
        }
        if (endOfTimestampsInterval > variables.getLastTimestampInCurrentInterval()) {
            if (variables.getFirstTimestampInCurrentInterval() >= 0L) {
                this.calculateAndDeliverAggregationValue(variables);
                long numIntervalsElapsed = 1L;
                numIntervalsElapsed = (endOfTimestampsInterval - variables.getLastTimestampInCurrentInterval()) / this.aggregationSpan;
                if (numIntervalsElapsed > 1L) {
                    int i = 1;
                    while ((long)i < numIntervalsElapsed) {
                        super.deliver(OUTPUT_PORT_NAME_AGGREGATED_TSPOINT, new NamedDoubleTimeSeriesPoint(variables.getLastTimestampInCurrentInterval() + (long)i * this.aggregationSpan, Double.NaN, appname));
                        ++i;
                    }
                }
            }
            variables.setFirstTimestampInCurrentInterval(startOfTimestampsInterval);
            variables.setLastTimestampInCurrentInterval(endOfTimestampsInterval);
            variables.getAggregationList().clear();
        }
        variables.getAggregationList().add(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAndDeliverAggregationValue(AggregationVariableSet variables) {
        NamedDoubleTimeSeriesPoint tsPoint;
        TimeSeriesPointAggregatorFilter timeSeriesPointAggregatorFilter = this;
        synchronized (timeSeriesPointAggregatorFilter) {
            int listSize = variables.getAggregationList().size();
            double[] a = new double[listSize];
            for (int i = 0; i < listSize; ++i) {
                a[i] = (Double)variables.getAggregationList().get(i).getValue();
            }
            double aggregationValue = this.aggregationMethod.getAggregationValue(a);
            tsPoint = new NamedDoubleTimeSeriesPoint(variables.getLastTimestampInCurrentInterval(), aggregationValue, variables.getAggregationList().get(0).getName());
            variables.getAggregationList().clear();
        }
        super.deliver(OUTPUT_PORT_NAME_AGGREGATED_TSPOINT, tsPoint);
    }

    private long computeFirstTimestampInInterval(long timestamp, AggregationVariableSet variables) {
        if (variables.getFirstIntervalStart() == -1L) {
            variables.setFirstIntervalStart(timestamp);
        }
        long referenceTimePoint = variables.getFirstIntervalStart();
        return referenceTimePoint + (timestamp - referenceTimePoint) / this.aggregationSpan * this.aggregationSpan;
    }

    private long computeLastTimestampInInterval(long timestamp, AggregationVariableSet variables) {
        long referenceTimePoint = variables.getFirstIntervalStart();
        return referenceTimePoint + (((timestamp - referenceTimePoint) / this.aggregationSpan + 1L) * this.aggregationSpan - 1L);
    }
}

