/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.operationExecution;

import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractOperationExecutionAspect
extends AbstractAspectJProbe {
    private static final Log LOG = LogFactory.getLog(AbstractOperationExecutionAspect.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String VMNAME = CTRLINST.getHostname();
    private static final ControlFlowRegistry CFREGISTRY = ControlFlowRegistry.INSTANCE;
    private static final SessionRegistry SESSIONREGISTRY = SessionRegistry.INSTANCE;

    @Pointcut
    public abstract /* synthetic */ void monitoredOperation();

    @Around(value="monitoredOperation() && notWithinKieker()")
    public Object operation(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        Object retval;
        int ess;
        int eoi;
        boolean entrypoint;
        if (!AbstractOperationExecutionAspect.CTRLINST.isMonitoringEnabled()) {
            return thisJoinPoint.proceed();
        }
        String signature = this.ajc$superDispatch$kieker_monitoring_probe_aspectj_operationExecution_AbstractOperationExecutionAspect$signatureToLongString(thisJoinPoint.getSignature());
        if (!AbstractOperationExecutionAspect.CTRLINST.isProbeActivated(signature)) {
            return thisJoinPoint.proceed();
        }
        String hostname = AbstractOperationExecutionAspect.VMNAME;
        String sessionId = AbstractOperationExecutionAspect.SESSIONREGISTRY.recallThreadLocalSessionId();
        long traceId = AbstractOperationExecutionAspect.CFREGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            entrypoint = true;
            traceId = AbstractOperationExecutionAspect.CFREGISTRY.getAndStoreUniqueThreadLocalTraceId();
            AbstractOperationExecutionAspect.CFREGISTRY.storeThreadLocalEOI(0);
            AbstractOperationExecutionAspect.CFREGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
        } else {
            entrypoint = false;
            eoi = AbstractOperationExecutionAspect.CFREGISTRY.incrementAndRecallThreadLocalEOI();
            ess = AbstractOperationExecutionAspect.CFREGISTRY.recallAndIncrementThreadLocalESS();
            if (eoi == -1 || ess == -1) {
                AbstractOperationExecutionAspect.LOG.error("eoi and/or ess have invalid values: eoi == " + eoi + " ess == " + ess);
                AbstractOperationExecutionAspect.CTRLINST.terminateMonitoring();
            }
        }
        long tin = AbstractOperationExecutionAspect.TIME.getTime();
        try {
            retval = thisJoinPoint.proceed();
        }
        finally {
            long tout = AbstractOperationExecutionAspect.TIME.getTime();
            AbstractOperationExecutionAspect.CTRLINST.newMonitoringRecord(new OperationExecutionRecord(signature, sessionId, traceId, tin, tout, hostname, eoi, ess));
            if (entrypoint) {
                AbstractOperationExecutionAspect.CFREGISTRY.unsetThreadLocalTraceId();
                AbstractOperationExecutionAspect.CFREGISTRY.unsetThreadLocalEOI();
                AbstractOperationExecutionAspect.CFREGISTRY.unsetThreadLocalESS();
            } else {
                AbstractOperationExecutionAspect.CFREGISTRY.storeThreadLocalESS(ess);
            }
        }
        return retval;
    }

    public /* synthetic */ String ajc$superDispatch$kieker_monitoring_probe_aspectj_operationExecution_AbstractOperationExecutionAspect$signatureToLongString(Signature signature) {
        return super.signatureToLongString(signature);
    }
}

