/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.IOperationRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.util.registry.IRegistry;

public abstract class AbstractOperationEvent
extends AbstractTraceEvent
implements IOperationRecord {
    private static final long serialVersionUID = -910233516407209980L;
    private final String operationSignature;
    private final String classSignature;

    public AbstractOperationEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature) {
        super(timestamp, traceId, orderIndex);
        this.operationSignature = operationSignature == null ? "" : operationSignature;
        this.classSignature = classSignature == null ? "" : classSignature;
    }

    protected AbstractOperationEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.operationSignature = (String)values[3];
        this.classSignature = (String)values[4];
    }

    public AbstractOperationEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.operationSignature = stringRegistry.get(buffer.getInt());
        this.classSignature = stringRegistry.get(buffer.getInt());
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getOperationSignature() {
        return this.operationSignature;
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }
}

