/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib.forecast.arima;

import kieker.tools.tslib.ForecastMethod;
import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.forecast.AbstractRForecaster;

public class ARIMA101Forecaster
extends AbstractRForecaster {
    private static final String FORECAST_FUNC_NAME = "predict";
    private static final String MODEL_FUNC_NAME = "arima";
    private final String[] emptyString = new String[0];

    public ARIMA101Forecaster(ITimeSeries<Double> historyTimeseries) {
        super(historyTimeseries, MODEL_FUNC_NAME, FORECAST_FUNC_NAME, ForecastMethod.ARIMA101);
    }

    public ARIMA101Forecaster(ITimeSeries<Double> historyTimeseries, int confidenceLevel) {
        super(historyTimeseries, MODEL_FUNC_NAME, FORECAST_FUNC_NAME, confidenceLevel, ForecastMethod.ARIMA101);
    }

    @Override
    protected String[] getModelFuncParams() {
        return new String[]{"c(1,0,1)", "method=\"CSS-ML\""};
    }

    @Override
    protected String[] getForecastFuncParams() {
        return (String[])this.emptyString.clone();
    }

    @Override
    protected String forecastOperationOnResult(String varNameForecast) {
        return String.format("%s$pred", varNameForecast);
    }

    @Override
    protected String lowerOperationOnResult(String varNameForecast) {
        return String.format("(%s$pred - %s$se)", varNameForecast, varNameForecast);
    }

    @Override
    protected String upperOperationOnResult(String varNameForecast) {
        return String.format("(%s$pred + %s$se)", varNameForecast, varNameForecast);
    }
}

