/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib.forecast;

import java.util.List;
import kieker.tools.tslib.ForecastMethod;
import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.forecast.IForecastResult;

public class ForecastResult
implements IForecastResult {
    private final ITimeSeries<Double> tsForecast;
    private final ITimeSeries<Double> tsOriginal;
    private final int confidenceLevel;
    private final double meanAbsoluteScaledError;
    private final ForecastMethod fcStrategy;
    private final ITimeSeries<Double> tsUpper;
    private final ITimeSeries<Double> tsLower;

    public ForecastResult(ITimeSeries<Double> tsForecast, ITimeSeries<Double> tsOriginal, int tsconfidenceLevel, double tsmeanAbsoluteScaledError, ITimeSeries<Double> tsLower, ITimeSeries<Double> tsUpper, ForecastMethod fcStrategy) {
        this.tsForecast = tsForecast;
        this.tsOriginal = tsOriginal;
        this.meanAbsoluteScaledError = tsmeanAbsoluteScaledError;
        this.confidenceLevel = tsconfidenceLevel;
        this.tsUpper = tsUpper;
        this.tsLower = tsLower;
        this.fcStrategy = fcStrategy;
    }

    public ForecastResult(ITimeSeries<Double> tsForecast, ITimeSeries<Double> tsOriginal, ForecastMethod fcStrategy) {
        this(tsForecast, tsOriginal, 0, 0.0, tsForecast, tsForecast, fcStrategy);
    }

    @Override
    public ITimeSeries<Double> getForecast() {
        return this.tsForecast;
    }

    @Override
    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    @Override
    public ITimeSeries<Double> getUpper() {
        return this.tsUpper;
    }

    @Override
    public ITimeSeries<Double> getLower() {
        return this.tsLower;
    }

    @Override
    public ITimeSeries<Double> getOriginal() {
        return this.tsOriginal;
    }

    public String toString() {
        StringBuilder strB = new StringBuilder(71);
        strB.append("\ntsForecast: ");
        strB.append(this.tsForecast.toString());
        strB.append("\ntsOriginal: ");
        strB.append(this.tsOriginal.toString());
        strB.append("\nconfidenceLevel: ");
        strB.append(this.confidenceLevel);
        strB.append("\ntsUpper: ");
        strB.append(this.tsUpper);
        strB.append("\ntsLower: ");
        strB.append(this.tsLower);
        strB.append('\n');
        return strB.toString();
    }

    @Override
    public double getMeanAbsoluteScaledError() {
        return this.meanAbsoluteScaledError;
    }

    @Override
    public ForecastMethod getFcStrategy() {
        return this.fcStrategy;
    }

    @Override
    public boolean isPlausible() {
        if (this.meanAbsoluteScaledError == 0.0 || Double.isNaN(this.meanAbsoluteScaledError)) {
            return false;
        }
        double maximumObserved = ForecastResult.calcMaximum(this.tsOriginal);
        List<Double> values = this.tsForecast.getValues();
        for (Double value : values) {
            if (!(value > maximumObserved * 2.0) && !(value < 0.0)) continue;
            return false;
        }
        return true;
    }

    private static double calcMaximum(ITimeSeries<Double> ts) {
        List<Double> values = ts.getValues();
        double max = 0.0;
        for (double t : values) {
            if (!(t > max)) continue;
            max = t;
        }
        return max;
    }
}

