/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel;

import java.util.Comparator;
import kieker.tools.traceAnalysis.systemModel.AbstractSession;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.util.TraceStartTimestampComparator;
import kieker.tools.util.LoggingTimestampConverter;

public class ExecutionTraceBasedSession
extends AbstractSession<ExecutionTrace> {
    public ExecutionTraceBasedSession(String sessionId) {
        super(sessionId);
    }

    @Override
    protected Comparator<? super ExecutionTrace> getOrderComparator() {
        return new TraceStartTimestampComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder strBuild = new StringBuilder(512);
        ExecutionTraceBasedSession executionTraceBasedSession = this;
        synchronized (executionTraceBasedSession) {
            strBuild.append("SessionId ").append(this.getSessionId());
            strBuild.append(" (startTime=").append(this.getStartTimestamp());
            strBuild.append(" (").append(LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.getStartTimestamp()));
            strBuild.append("); endTime=").append(this.getEndTimestamp());
            strBuild.append(" (").append(LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.getEndTimestamp()));
            strBuild.append("):\n");
            for (ExecutionTrace t : this.getContainedTraces()) {
                strBuild.append('{');
                strBuild.append(t.toString()).append("}\n");
            }
        }
        return strBuild.toString();
    }
}

