/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kieker.tools.traceAnalysis.gui.AbstractStep;
import kieker.tools.traceAnalysis.gui.util.FileChooserActionListener;

public class WelcomeStep
extends AbstractStep {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_KEY_IDENTIFIER = WelcomeStep.class.getSimpleName();
    private static final String PROPERTY_KEY_OUTPUT_DIRECTORY = PROPERTY_KEY_IDENTIFIER + ".outputDirectory";
    private static final String PROPERTY_KEY_INPUT_DIRECTORY = PROPERTY_KEY_IDENTIFIER + ".inputDirectory";
    private final JLabel welcomeLabel = new JLabel("<html>Welcome to Kieker's Trace Analysis GUI.<br/>This wizard helps you generating visual representatons based on a trace analysis of your records.<br/><br/>In this step you choose the input input and output directories.</html>");
    private final JLabel inputDirectoryLabel = new JLabel("Input Directory: ");
    private final JLabel outputDirectoryLabel = new JLabel("Output Directory: ");
    private final JTextField inputDirectoryTextField = new JTextField();
    private final JTextField outputDirectoryTextField = new JTextField();
    private final JButton inputDirectoryChooseButton = new JButton("Choose");
    private final JButton outputDirectoryChooseButton = new JButton("Choose");
    private final JPanel expandingPanel = new JPanel();

    public WelcomeStep() {
        this.addAndLayoutComponents();
        this.addLogicToComponents();
        this.addToolTipsToComponents();
    }

    private void addAndLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.welcomeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.inputDirectoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.inputDirectoryTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.inputDirectoryChooseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.add((Component)this.outputDirectoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.outputDirectoryTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        this.add((Component)this.outputDirectoryChooseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.expandingPanel, gridBagConstraints);
    }

    private void addLogicToComponents() {
        this.inputDirectoryChooseButton.addActionListener(FileChooserActionListener.createDirectoryChooserActionListener(this.inputDirectoryTextField, this));
        this.outputDirectoryChooseButton.addActionListener(FileChooserActionListener.createDirectoryChooserActionListener(this.outputDirectoryTextField, this));
    }

    private void addToolTipsToComponents() {
        this.inputDirectoryTextField.setToolTipText("The input directory contains usually monitoring records for the analysis.");
        this.outputDirectoryTextField.setToolTipText("The output directory is used to write the visual representations from the analysis.");
    }

    @Override
    public boolean isNextStepAllowed() {
        int result;
        File inputDirectory = new File(this.inputDirectoryTextField.getText());
        if (!inputDirectory.isDirectory() && 1 == (result = JOptionPane.showConfirmDialog(this, "The input directory does not exist. Continue?", "Input Directory", 0, 2))) {
            return false;
        }
        File outputDirectory = new File(this.outputDirectoryTextField.getText());
        if (outputDirectory.isDirectory()) {
            return true;
        }
        int result2 = JOptionPane.showConfirmDialog(this, "The output directory does not exist. Create it?", "Output Directory", 0, 3);
        if (0 == result2) {
            return outputDirectory.mkdirs();
        }
        return false;
    }

    public String getOutputDirectory() {
        return this.outputDirectoryTextField.getText();
    }

    @Override
    public void addSelectedTraceAnalysisParameters(Collection<String> parameters) {
        parameters.add("--inputdirs");
        parameters.add("\"" + this.inputDirectoryTextField.getText() + "\"");
        parameters.add("--outputdir");
        parameters.add("\"" + this.outputDirectoryTextField.getText() + "\"");
    }

    @Override
    public void saveCurrentConfiguration(Properties properties) {
        properties.setProperty(PROPERTY_KEY_INPUT_DIRECTORY, this.inputDirectoryTextField.getText());
        properties.setProperty(PROPERTY_KEY_OUTPUT_DIRECTORY, this.outputDirectoryTextField.getText());
    }

    @Override
    public void loadCurrentConfiguration(Properties properties) {
        this.inputDirectoryTextField.setText(properties.getProperty(PROPERTY_KEY_INPUT_DIRECTORY));
        this.outputDirectoryTextField.setText(properties.getProperty(PROPERTY_KEY_OUTPUT_DIRECTORY));
    }

    @Override
    public void loadDefaultConfiguration() {
        String currentPath = new File(".").getAbsolutePath();
        this.inputDirectoryTextField.setText(currentPath);
        this.outputDirectoryTextField.setText(currentPath);
    }
}

