/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.TraceAnalysisTool;
import kieker.tools.traceAnalysis.gui.AbstractStep;
import kieker.tools.traceAnalysis.gui.AdditionalFiltersStep;
import kieker.tools.traceAnalysis.gui.AdditionalOptionsStep;
import kieker.tools.traceAnalysis.gui.ConversionStep;
import kieker.tools.traceAnalysis.gui.FinalStep;
import kieker.tools.traceAnalysis.gui.PlotStep;
import kieker.tools.traceAnalysis.gui.PrintStep;
import kieker.tools.traceAnalysis.gui.WelcomeStep;

public class TraceAnalysisGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(TraceAnalysisGUI.class);
    private final CardLayout mainPanelLayout = new CardLayout();
    private final JPanel mainPanel = new JPanel(this.mainPanelLayout);
    private final JButton previousButton = new JButton("Previous");
    private final JButton nextButton = new JButton("Next");
    private final StartTraceAnalysisActionListener startTraceAnalysisClickListener = new StartTraceAnalysisActionListener();
    private final ConversionStep conversionStep = new ConversionStep();
    private final WelcomeStep welcomeStep = new WelcomeStep();
    private final FinalStep finalStep = new FinalStep(this.startTraceAnalysisClickListener);
    private final AbstractStep[] steps = new AbstractStep[]{this.welcomeStep, new PlotStep(), new PrintStep(), new AdditionalOptionsStep(), new AdditionalFiltersStep(), this.conversionStep, this.finalStep};
    private int currentStepIndex;

    public TraceAnalysisGUI() {
        super("Trace Analysis Tool - GUI");
        this.addAndLayoutComponents();
        this.initializeComponents();
        this.addLogicToComponents();
        this.initializeWindow();
        this.loadCurrentConfiguration();
    }

    private void addAndLayoutComponents() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.mainPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)this.previousButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)this.nextButton, gridBagConstraints);
    }

    private void initializeComponents() {
        this.previousButton.setEnabled(false);
    }

    private void addLogicToComponents() {
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TraceAnalysisGUI.this.nextStep();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceAnalysisGUI.this.previousStep();
            }
        });
    }

    private void nextStep() {
        if (this.steps[this.currentStepIndex].isNextStepAllowed()) {
            ++this.currentStepIndex;
            this.mainPanelLayout.next(this.mainPanel);
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(this.currentStepIndex < this.steps.length - 1);
            this.saveCurrentConfiguration();
        }
    }

    private void previousStep() {
        --this.currentStepIndex;
        this.mainPanelLayout.previous(this.mainPanel);
        this.nextButton.setEnabled(true);
        this.previousButton.setEnabled(this.currentStepIndex > 0);
        this.saveCurrentConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCurrentConfiguration() {
        InputStreamReader propertiesFileInputStream = null;
        try {
            propertiesFileInputStream = new InputStreamReader((InputStream)new FileInputStream("TraceAnalysisGUI.properties"), "UTF-8");
            Properties properties = new Properties();
            properties.load(propertiesFileInputStream);
            for (AbstractStep step : this.steps) {
                step.loadCurrentConfiguration(properties);
            }
        }
        catch (Exception ex) {
            for (AbstractStep step : this.steps) {
                step.loadDefaultConfiguration();
            }
        }
        finally {
            if (null != propertiesFileInputStream) {
                try {
                    propertiesFileInputStream.close();
                }
                catch (IOException e) {
                    LOG.warn("Could not close input stream", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentConfiguration() {
        Properties properties = new Properties();
        for (AbstractStep step : this.steps) {
            step.saveCurrentConfiguration(properties);
        }
        OutputStreamWriter stream = null;
        try {
            stream = new OutputStreamWriter((OutputStream)new FileOutputStream("TraceAnalysisGUI.properties"), "UTF-8");
            properties.store(stream, null);
        }
        catch (IOException ex) {
            LOG.warn("Configuration could not be saved", ex);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.warn("Could not close output stream", e);
                }
            }
        }
    }

    private void initializeWindow() {
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        int maxHeight = 1;
        int maxWidth = 1;
        for (AbstractStep panel : this.steps) {
            this.mainPanel.add((Component)panel, panel.toString());
            maxHeight = Math.max(maxHeight, panel.getPreferredSize().height);
            maxWidth = Math.max(maxWidth, panel.getPreferredSize().width);
        }
        this.setSize(maxWidth, maxHeight);
        this.setLocationRelativeTo(null);
    }

    private void startTraceAnalysis() {
        final ArrayList<String> parameters = new ArrayList<String>();
        for (AbstractStep step : this.steps) {
            step.addSelectedTraceAnalysisParameters(parameters);
        }
        this.previousButton.setEnabled(false);
        this.finalStep.disableButtons();
        Thread thread = new Thread(){

            @Override
            public void run() {
                TraceAnalysisTool.mainHelper(parameters.toArray(new String[parameters.size()]), false);
                TraceAnalysisGUI.this.conversionStep.convert(TraceAnalysisGUI.this.welcomeStep.getOutputDirectory());
                TraceAnalysisGUI.this.previousButton.setEnabled(true);
                TraceAnalysisGUI.this.finalStep.enableButtons();
            }
        };
        thread.start();
    }

    public static void main(String[] args) {
        TraceAnalysisGUI gui = new TraceAnalysisGUI();
        gui.setVisible(true);
    }

    private class StartTraceAnalysisActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            TraceAnalysisGUI.this.startTraceAnalysis();
        }
    }
}

