/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.explorviz;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.IObjectRecord;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.misc.RegistryRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncThread;

final class ExplorVizExportWriterThread
extends AbstractAsyncThread {
    private static final Log LOG = LogFactory.getLog(ExplorVizExportWriterThread.class);
    private static final byte HOST_APPLICATION_META_DATA_CLAZZ_ID = 0;
    private static final byte BEFORE_OPERATION_CLAZZ_ID = 1;
    private static final byte AFTER_FAILED_OPERATION_CLAZZ_ID = 2;
    private static final byte AFTER_OPERATION_CLAZZ_ID = 3;
    private static final byte STRING_REGISTRY_CLAZZ_ID = 4;
    private final SocketChannel socketChannel;
    private final ByteBuffer byteBuffer;
    private final boolean flush;

    public ExplorVizExportWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, String hostname, int port, int bufferSize, boolean flush) throws IOException {
        super(monitoringController, writeQueue);
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.socketChannel = SocketChannel.open(new InetSocketAddress(hostname, port));
        this.flush = flush;
        this.byteBuffer.put((byte)0);
        String systemName = "Default System";
        int systemId = this.monitoringController.getUniqueIdForString("Default System");
        this.byteBuffer.putInt(systemId);
        String ip = InetAddress.getLocalHost().getHostAddress();
        int ipId = this.monitoringController.getUniqueIdForString(ip);
        this.byteBuffer.putInt(ipId);
        String localHostname = monitoringController.getHostname();
        int localHostnameId = this.monitoringController.getUniqueIdForString(localHostname);
        this.byteBuffer.putInt(localHostnameId);
        String applicatioName = monitoringController.getName();
        int applicationId = this.monitoringController.getUniqueIdForString(applicatioName);
        this.byteBuffer.putInt(applicationId);
        this.putRegistryRecordIntoBuffer(new RegistryRecord(systemId, "Default System"));
        this.putRegistryRecordIntoBuffer(new RegistryRecord(ipId, ip));
        this.putRegistryRecordIntoBuffer(new RegistryRecord(localHostnameId, localHostname));
        this.putRegistryRecordIntoBuffer(new RegistryRecord(applicationId, applicatioName));
        this.send();
    }

    @Override
    protected void consume(IMonitoringRecord monitoringRecord) throws Exception {
        int recordSize = 0;
        if (monitoringRecord instanceof BeforeOperationEvent) {
            recordSize = 37;
        } else if (monitoringRecord instanceof AfterOperationFailedEvent) {
            recordSize = 25;
        } else if (monitoringRecord instanceof AfterOperationEvent) {
            recordSize = 21;
        } else if (monitoringRecord instanceof RegistryRecord) {
            RegistryRecord registryRecord = (RegistryRecord)monitoringRecord;
            recordSize = 9 + registryRecord.getStrBytes().length;
        }
        ByteBuffer buffer = this.byteBuffer;
        if (recordSize > buffer.remaining()) {
            this.send();
        }
        this.convertKiekerToExplorViz(buffer, monitoringRecord);
        if (this.flush) {
            this.send();
        }
    }

    private void convertKiekerToExplorViz(ByteBuffer buffer, IMonitoringRecord kiekerRecord) {
        if (kiekerRecord instanceof BeforeOperationEvent) {
            BeforeOperationEvent kiekerBefore = (BeforeOperationEvent)kiekerRecord;
            buffer.put((byte)1);
            buffer.putLong(kiekerBefore.getTimestamp());
            buffer.putLong(kiekerBefore.getTraceId());
            buffer.putInt(kiekerBefore.getOrderIndex());
            if (kiekerRecord instanceof IObjectRecord) {
                IObjectRecord iObjectRecord = (IObjectRecord)kiekerRecord;
                buffer.putInt(iObjectRecord.getObjectId());
            } else {
                buffer.putInt(0);
            }
            buffer.putInt(this.monitoringController.getUniqueIdForString(kiekerBefore.getOperationSignature()));
            buffer.putInt(this.monitoringController.getUniqueIdForString(kiekerBefore.getClassSignature()));
            buffer.putInt(this.monitoringController.getUniqueIdForString(""));
        } else if (kiekerRecord instanceof AfterOperationFailedEvent) {
            AfterOperationFailedEvent kiekerAfterFailed = (AfterOperationFailedEvent)kiekerRecord;
            buffer.put((byte)2);
            buffer.putLong(kiekerAfterFailed.getTimestamp());
            buffer.putLong(kiekerAfterFailed.getTraceId());
            buffer.putInt(kiekerAfterFailed.getOrderIndex());
            buffer.putInt(this.monitoringController.getUniqueIdForString(kiekerAfterFailed.getCause()));
        } else if (kiekerRecord instanceof AfterOperationEvent) {
            AfterOperationEvent kiekerAfter = (AfterOperationEvent)kiekerRecord;
            buffer.put((byte)3);
            buffer.putLong(kiekerAfter.getTimestamp());
            buffer.putLong(kiekerAfter.getTraceId());
            buffer.putInt(kiekerAfter.getOrderIndex());
        } else if (kiekerRecord instanceof RegistryRecord) {
            RegistryRecord registryRecord = (RegistryRecord)kiekerRecord;
            this.putRegistryRecordIntoBuffer(registryRecord);
        }
    }

    private void putRegistryRecordIntoBuffer(RegistryRecord registryRecord) {
        byte[] valueAsBytes = registryRecord.getStrBytes();
        this.byteBuffer.put((byte)4);
        this.byteBuffer.putInt(registryRecord.getId());
        this.byteBuffer.putInt(valueAsBytes.length);
        this.byteBuffer.put(valueAsBytes);
    }

    private void send() throws IOException {
        this.byteBuffer.flip();
        while (this.byteBuffer.hasRemaining()) {
            this.socketChannel.write(this.byteBuffer);
        }
        this.byteBuffer.clear();
    }

    @Override
    protected void cleanup() {
        try {
            this.send();
            this.socketChannel.close();
        }
        catch (IOException ex) {
            LOG.error("Error closing connection", ex);
        }
    }
}

