/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.ILookup;
import kieker.common.util.registry.IRegistry;

public final class RegistryRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 8;
    public static final Class<?>[] TYPES = new Class[]{Integer.TYPE, String.class};
    public static final String ENCODING = "UTF-8";
    private static final long serialVersionUID = -8264706549927546468L;
    private final int id;
    private final String string;
    private final byte[] strBytes;

    public RegistryRecord(int id, String string) {
        byte[] tmpBytes;
        this.id = id;
        this.string = string;
        try {
            tmpBytes = this.getString().getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            tmpBytes = this.getString().getBytes();
        }
        this.strBytes = tmpBytes;
    }

    public RegistryRecord(Object[] values) {
        byte[] tmpBytes;
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.id = (Integer)values[0];
        this.string = (String)values[1];
        try {
            tmpBytes = this.getString().getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            tmpBytes = this.getString().getBytes();
        }
        this.strBytes = tmpBytes;
    }

    public RegistryRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        String str;
        this.id = buffer.getInt();
        this.strBytes = new byte[buffer.getInt()];
        buffer.get(this.strBytes);
        try {
            str = new String(this.strBytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            str = new String(this.strBytes);
        }
        this.string = str;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getId(), this.getString()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putInt(this.getId());
        buffer.putInt(this.getString().length());
        buffer.put(this.strBytes);
    }

    @Override
    @Deprecated
    public final void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 8 + this.strBytes.length;
    }

    public final byte[] getStrBytes() {
        return this.strBytes;
    }

    public final int getId() {
        return this.id;
    }

    public final String getString() {
        return this.string;
    }

    public static final void registerRecordInRegistry(ByteBuffer buffer, ILookup<String> stringRegistry) throws BufferOverflowException {
        String string;
        int id = buffer.getInt();
        byte[] strBytes = new byte[buffer.getInt()];
        buffer.get(strBytes);
        try {
            string = new String(strBytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            string = new String(strBytes);
        }
        stringRegistry.set(string, id);
    }
}

