/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import java.util.concurrent.TimeUnit;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractNodeDecorator;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.traceAnalysis.filter.visualization.graph.Color;
import kieker.tools.traceAnalysis.systemModel.AbstractMessage;

public class ResponseTimeColorNodeDecorator
extends AbstractNodeDecorator {
    private static final TimeUnit DISPLAY_TIMEUNIT = TimeUnit.MILLISECONDS;
    private static final Color COLOR = Color.RED;
    private final int threshold;

    public ResponseTimeColorNodeDecorator(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void processMessage(AbstractMessage message, DependencyGraphNode<?> sourceNode, DependencyGraphNode<?> targetNode, TimeUnit timeunit) {
        if (sourceNode.equals(targetNode)) {
            return;
        }
        long responseTime = message.getReceivingExecution().getTout() - message.getReceivingExecution().getTin();
        int convertedResponseTime = (int)DISPLAY_TIMEUNIT.convert(responseTime, timeunit);
        if (convertedResponseTime > this.threshold) {
            targetNode.setColor(COLOR);
        }
    }
}

