/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.model.ForecastMeasurementPair;
import kieker.tools.opad.model.IForecastMeasurementPair;
import kieker.tools.opad.model.NamedDoubleTimeSeriesPoint;

@Plugin(name="VariateUniteForecastingMeasurementPair Filter", outputPorts={@OutputPort(eventTypes={IForecastMeasurementPair.class}, name="forecastedcurrent")})
public class UniteMeasurementPairFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_TSPOINT = "tspoint";
    public static final String INPUT_PORT_NAME_FORECAST = "forecast";
    public static final String OUTPUT_PORT_NAME_FORECASTED_AND_CURRENT = "forecastedcurrent";
    private final ConcurrentHashMap<String, NamedDoubleTimeSeriesPoint> tsPointMap = new ConcurrentHashMap();
    private final List<String> firstIncomingTSPointList = Collections.synchronizedList(new ArrayList());

    public UniteMeasurementPairFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    @InputPort(eventTypes={NamedDoubleTimeSeriesPoint.class}, name="tspoint")
    public void inputTSPoint(NamedDoubleTimeSeriesPoint input) {
        if (!this.checkCorrespondingForecast(input)) {
            this.addTsPoint(input);
        }
    }

    @InputPort(eventTypes={IForecastMeasurementPair.class}, name="forecast")
    public void inputForecastValue(IForecastMeasurementPair input) {
        NamedDoubleTimeSeriesPoint pointFromForecast = new NamedDoubleTimeSeriesPoint(input.getTime(), input.getForecasted(), input.getName());
        if (!this.checkCorrespondingMeasurement(pointFromForecast)) {
            this.addTsPoint(pointFromForecast);
        }
    }

    private void addTsPoint(NamedDoubleTimeSeriesPoint p) {
        this.tsPointMap.put(p.getTime() + "." + p.getName(), p);
    }

    private boolean checkCorrespondingForecast(NamedDoubleTimeSeriesPoint p) {
        if (!this.firstIncomingTSPointList.contains(p.getName())) {
            this.firstIncomingTSPointList.add(p.getName());
            ForecastMeasurementPair fmp = new ForecastMeasurementPair(p.getName(), (Double)p.getValue(), (Double)p.getValue(), p.getTime());
            super.deliver(OUTPUT_PORT_NAME_FORECASTED_AND_CURRENT, fmp);
            return true;
        }
        String key = p.getTime() + "." + p.getName();
        if (this.tsPointMap.containsKey(key)) {
            ForecastMeasurementPair fmp = new ForecastMeasurementPair(p.getName(), (Double)this.tsPointMap.get(key).getValue(), (Double)p.getValue(), p.getTime());
            super.deliver(OUTPUT_PORT_NAME_FORECASTED_AND_CURRENT, fmp);
            this.tsPointMap.remove(key);
            return true;
        }
        return false;
    }

    private boolean checkCorrespondingMeasurement(NamedDoubleTimeSeriesPoint p) {
        String key = p.getTime() + "." + p.getName();
        if (this.tsPointMap.containsKey(key)) {
            NamedDoubleTimeSeriesPoint m = this.tsPointMap.get(key);
            ForecastMeasurementPair fmp = new ForecastMeasurementPair(m.getName(), (Double)p.getValue(), (Double)m.getValue(), m.getTime());
            super.deliver(OUTPUT_PORT_NAME_FORECASTED_AND_CURRENT, fmp);
            this.tsPointMap.remove(key);
            return true;
        }
        return false;
    }
}

