/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.configuration.ConfigurationFactory;
import kieker.tools.bridge.IServiceListener;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.ServiceContainer;
import kieker.tools.bridge.cli.CLIConfigurationErrorException;
import kieker.tools.bridge.cli.PrivilegedClassLoaderAction;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorProperty;
import kieker.tools.bridge.connector.IServiceConnector;
import kieker.tools.bridge.connector.ServiceConnectorFactory;
import kieker.tools.bridge.connector.jms.JMSClientConnector;
import kieker.tools.bridge.connector.jms.JMSEmbeddedConnector;
import kieker.tools.bridge.connector.tcp.TCPClientConnector;
import kieker.tools.bridge.connector.tcp.TCPMultiServerConnector;
import kieker.tools.bridge.connector.tcp.TCPSingleServerConnector;
import kieker.tools.util.CLIHelpFormatter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class CLIServerMain {
    private static final Log LOG = LogFactory.getLog(CLIServerMain.class);
    private static final String CMD_TYPE = "t";
    private static final String CMD_TYPE_LONG = "type";
    private static final String CMD_HOST = "h";
    private static final String CMD_HOST_LONG = "host";
    private static final String CMD_PORT = "p";
    private static final String CMD_PORT_LONG = "port";
    private static final String CMD_USER = "u";
    private static final String CMD_USER_LONG = "user";
    private static final String CMD_PASSWORD = "w";
    private static final String CMD_PASSWORD_LONG = "password";
    private static final String CMD_URL = "l";
    private static final String CMD_URL_LONG = "url";
    private static final String CMD_KIEKER_CONFIGURATION = "c";
    private static final String CMD_KIEKER_CONFIGURATION_LONG = "configuration";
    private static final String CMD_LIBRARIES = "L";
    private static final String CMD_LIBRARIES_LONG = "libraries";
    private static final String CMD_DAEMON = "d";
    private static final String CMD_DAEMON_LONG = "daemon";
    private static final String CMD_STATS = "s";
    private static final String CMD_STATS_LONG = "stats";
    private static final String CMD_VERBOSE = "v";
    private static final String CMD_VERBOSE_LONG = "verbose";
    private static final String CMD_MAP_FILE = "m";
    private static final String CMD_MAP_FILE_LONG = "map";
    private static final String DAEMON_FILE = "daemon.pidfile";
    private static final String JAVA_TMP_DIR = "java.io.tmpdir";
    private static final String CLI_CONNECTOR = "kieker.tools.bridge.connector";
    private static boolean verbose;
    private static boolean stats;
    private static long startTime;
    private static long deltaTime;
    private static Options options;
    private static CommandLine commandLine;
    private static URLClassLoader classLoader;
    private static ServiceContainer container;

    private CLIServerMain() {
    }

    public static void main(String[] args) {
        int exitCode = 0;
        CLIServerMain.declareOptions();
        try {
            commandLine = new BasicParser().parse(options, args);
            verbose = commandLine.hasOption(CMD_VERBOSE);
            stats = commandLine.hasOption(CMD_STATS);
            if (commandLine.hasOption(CMD_DAEMON)) {
                System.out.close();
                System.err.close();
                CLIServerMain.getPidFile().deleteOnExit();
            }
            ConcurrentMap<Integer, LookupEntity> lookupEntityMap = ServiceConnectorFactory.createLookupEntityMap(CLIServerMain.createRecordMap());
            Configuration configuration = commandLine.hasOption(CMD_KIEKER_CONFIGURATION) ? ConfigurationFactory.createConfigurationFromFile(commandLine.getOptionValue(CMD_KIEKER_CONFIGURATION)) : ConfigurationFactory.createSingletonConfiguration();
            if (commandLine.hasOption(CMD_PORT)) {
                configuration.setProperty(JMSEmbeddedConnector.PORT, commandLine.getOptionValue(CMD_PORT));
                configuration.setProperty(TCPSingleServerConnector.PORT, commandLine.getOptionValue(CMD_PORT));
                configuration.setProperty(TCPMultiServerConnector.PORT, commandLine.getOptionValue(CMD_PORT));
                configuration.setProperty(TCPClientConnector.PORT, commandLine.getOptionValue(CMD_PORT));
            }
            if (commandLine.hasOption(CMD_HOST)) {
                configuration.setProperty(TCPClientConnector.HOSTNAME, commandLine.getOptionValue(CMD_HOST));
            }
            if (commandLine.hasOption(CMD_USER)) {
                configuration.setProperty(JMSClientConnector.USERNAME, commandLine.getOptionValue(CMD_USER));
            }
            if (commandLine.hasOption(CMD_PASSWORD)) {
                configuration.setProperty(JMSClientConnector.PASSWORD, commandLine.getOptionValue(CMD_PASSWORD));
            }
            if (commandLine.hasOption(CMD_URL)) {
                configuration.setProperty(JMSClientConnector.URI, commandLine.getOptionValue(CMD_URL));
            }
            if (commandLine.hasOption(CMD_TYPE)) {
                Reflections reflections = new Reflections(CLI_CONNECTOR, new Scanner[0]);
                Set connectors = reflections.getTypesAnnotatedWith(ConnectorProperty.class);
                for (Class connector : connectors) {
                    if (!connector.getAnnotation(ConnectorProperty.class).cmdName().equals(commandLine.getOptionValue(CMD_TYPE))) continue;
                    configuration.setProperty(CLI_CONNECTOR, connector.getCanonicalName());
                    break;
                }
            }
            IServiceConnector connector = CLIServerMain.createService(configuration, lookupEntityMap);
            CLIServerMain.getLog().info("Service " + connector.getClass().getAnnotation(ConnectorProperty.class).name());
            CLIServerMain.runService(configuration, connector);
        }
        catch (ParseException e) {
            CLIServerMain.usage("Parsing failed.  Reason: " + e.getMessage());
            exitCode = 4;
        }
        catch (IOException e) {
            CLIServerMain.usage("Mapping file read error: " + e.getMessage());
            exitCode = 1;
        }
        catch (CLIConfigurationErrorException e) {
            CLIServerMain.usage("Configuration error: " + e.getMessage());
            exitCode = 2;
        }
        catch (ConnectorDataTransmissionException e) {
            CLIServerMain.usage("Communication error: " + e.getMessage());
            exitCode = 3;
        }
        System.exit(exitCode);
    }

    private static void runService(Configuration configuration, IServiceConnector connector) throws ConnectorDataTransmissionException {
        if (verbose) {
            String updateIntervalParam = commandLine.getOptionValue(CMD_VERBOSE);
            container.setListenerUpdateInterval(updateIntervalParam != null ? Long.parseLong(updateIntervalParam) : 100L);
            container.addListener(new IServiceListener(){

                @Override
                public void handleEvent(long count, String message) {
                    CLIServerMain.getLog().info("Received " + count + " records");
                }
            });
        }
        if (stats) {
            startTime = System.nanoTime();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    CLIServerMain.shutdown();
                }
                catch (ConnectorDataTransmissionException e) {
                    CLIServerMain.getLog().error("Graceful shutdown failed.");
                    CLIServerMain.getLog().error("Cause " + e.getMessage());
                }
            }
        });
        container = new ServiceContainer(configuration, connector, false);
        container.run();
        if (stats) {
            deltaTime = System.nanoTime() - startTime;
        }
        if (verbose) {
            CLIServerMain.getLog().info("Server stopped.");
        }
        if (stats) {
            CLIServerMain.getLog().info("Execution time: " + deltaTime + " ns  " + TimeUnit.SECONDS.convert(deltaTime, TimeUnit.NANOSECONDS) + " s");
            CLIServerMain.getLog().info("Time per records: " + deltaTime / container.getRecordCount() + " ns/r");
            CLIServerMain.getLog().info("Records per second: " + (double)container.getRecordCount() / (double)TimeUnit.SECONDS.convert(deltaTime, TimeUnit.NANOSECONDS));
        }
    }

    protected static void shutdown() throws ConnectorDataTransmissionException {
        container.shutdown();
    }

    private static ConcurrentMap<Integer, Class<? extends IMonitoringRecord>> createRecordMap() throws IOException, CLIConfigurationErrorException {
        if (commandLine.hasOption(CMD_LIBRARIES)) {
            String[] libraries = commandLine.getOptionValues(CMD_LIBRARIES);
            if (commandLine.hasOption(CMD_MAP_FILE)) {
                ConcurrentMap<Integer, Class<? extends IMonitoringRecord>> recordMap = CLIServerMain.readMapping(libraries, commandLine.getOptionValue(CMD_MAP_FILE));
                if (recordMap.isEmpty()) {
                    throw new CLIConfigurationErrorException("At least one mapping must be specified in the mapping file.");
                }
                return recordMap;
            }
            throw new CLIConfigurationErrorException("Mapping file is required.");
        }
        throw new CLIConfigurationErrorException("At least one library reference is required.");
    }

    private static IServiceConnector createService(Configuration configuration, ConcurrentMap<Integer, LookupEntity> lookupEntityMap) throws CLIConfigurationErrorException, ConnectorDataTransmissionException {
        try {
            return CLIServerMain.createConnector(ClassLoader.getSystemClassLoader().loadClass(configuration.getStringProperty(CLI_CONNECTOR)), configuration, lookupEntityMap);
        }
        catch (ClassNotFoundException e) {
            throw new CLIConfigurationErrorException("Specified bridge connector " + configuration.getStringProperty(CLI_CONNECTOR) + " not found.", e);
        }
    }

    private static IServiceConnector createConnector(Class<?> connector, Configuration configuration, ConcurrentMap<Integer, LookupEntity> lookupEntityMap) throws CLIConfigurationErrorException {
        try {
            return (IServiceConnector)connector.getConstructor(Configuration.class, ConcurrentMap.class).newInstance(configuration, lookupEntityMap);
        }
        catch (IllegalArgumentException e) {
            throw new CLIConfigurationErrorException("Broken implementation of the selected connector " + connector.getCanonicalName(), e);
        }
        catch (SecurityException e) {
            throw new CLIConfigurationErrorException("Cannot access included classes " + connector.getCanonicalName(), e);
        }
        catch (InstantiationException e) {
            throw new CLIConfigurationErrorException("Instantiation failed for " + connector.getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new CLIConfigurationErrorException("Access prohibited to class " + connector.getCanonicalName(), e);
        }
        catch (InvocationTargetException e) {
            throw new CLIConfigurationErrorException("Broken implementation of the selected connector " + connector.getCanonicalName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new CLIConfigurationErrorException("Broken implementation of the selected connector " + connector.getCanonicalName(), e);
        }
    }

    private static void usage(String message) {
        CLIServerMain.getLog().error(message);
        CLIHelpFormatter formatter = new CLIHelpFormatter();
        formatter.printHelp("cli-kieker-service", options, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<Integer, Class<? extends IMonitoringRecord>> readMapping(String[] libraries, String filename) throws IOException {
        ConcurrentHashMap<Integer, Class<? extends IMonitoringRecord>> map = new ConcurrentHashMap<Integer, Class<? extends IMonitoringRecord>>();
        URL[] urls = new URL[libraries.length];
        for (int i = 0; i < libraries.length; ++i) {
            urls[i] = new File(libraries[i]).toURI().toURL();
        }
        PrivilegedClassLoaderAction action = new PrivilegedClassLoaderAction(urls);
        classLoader = AccessController.doPrivileged(action);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            String line = null;
            do {
                try {
                    String[] pair;
                    line = in.readLine();
                    if (line == null || (pair = line.split("=")).length != 2) continue;
                    map.put(Integer.parseInt(pair[0]), classLoader.loadClass(pair[1]));
                }
                catch (ClassNotFoundException e) {
                    CLIServerMain.getLog().warn("Could not load class", e);
                }
            } while (line != null);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return map;
    }

    private static Options declareOptions() {
        options = new Options();
        Option option = new Option(CMD_TYPE, CMD_TYPE_LONG, true, "select the service type: tcp-client, tcp-server, tcp-single-server, jms-client, jms-embedded");
        option.setArgName(CMD_TYPE_LONG);
        option.setRequired(true);
        options.addOption(option);
        option = new Option(CMD_HOST, CMD_HOST_LONG, true, "connect to server named <hostname>");
        option.setArgName("hostname");
        options.addOption(option);
        option = new Option(CMD_PORT, CMD_PORT_LONG, true, "listen at port (tcp-server or jms-embedded) or connect to port (tcp-client)");
        option.setArgName("number");
        option.setType(Number.class);
        options.addOption(option);
        option = new Option(CMD_USER, CMD_USER_LONG, true, "user name for a JMS service");
        option.setArgName("username");
        options.addOption(option);
        option = new Option(CMD_PASSWORD, CMD_PASSWORD_LONG, true, "password for a JMS service");
        option.setArgName(CMD_PASSWORD_LONG);
        options.addOption(option);
        option = new Option(CMD_URL, CMD_URL_LONG, true, "URL for JMS server");
        option.setArgName("jms-url");
        option.setType(URL.class);
        options.addOption(option);
        option = new Option(CMD_KIEKER_CONFIGURATION, CMD_KIEKER_CONFIGURATION_LONG, true, "kieker configuration file");
        option.setArgName(CMD_KIEKER_CONFIGURATION_LONG);
        options.addOption(option);
        option = new Option(CMD_MAP_FILE, CMD_MAP_FILE_LONG, true, "Class name to id (integer or string) mapping");
        option.setArgName("map-file");
        option.setType(File.class);
        option.setRequired(true);
        options.addOption(option);
        option = new Option(CMD_LIBRARIES, CMD_LIBRARIES_LONG, true, "List of library paths separated by " + File.pathSeparatorChar);
        option.setArgName("paths");
        option.setType(File.class);
        option.setRequired(true);
        option.setValueSeparator(File.pathSeparatorChar);
        options.addOption(option);
        option = new Option(CMD_VERBOSE, CMD_VERBOSE_LONG, true, "output processing information");
        option.setRequired(false);
        option.setOptionalArg(true);
        options.addOption(option);
        option = new Option(CMD_STATS, CMD_STATS_LONG, false, "output performance statistics");
        option.setRequired(false);
        options.addOption(option);
        option = new Option(CMD_DAEMON, CMD_DAEMON_LONG, false, "detach from console; TCP server allows multiple connections");
        option.setRequired(false);
        options.addOption(option);
        return options;
    }

    private static File getPidFile() throws IOException {
        File pidFile = null;
        if (System.getProperty(DAEMON_FILE) != null) {
            pidFile = new File(System.getProperty(DAEMON_FILE));
        } else if (new File(System.getProperty(JAVA_TMP_DIR)).exists()) {
            pidFile = new File(System.getProperty(JAVA_TMP_DIR) + "/kdb.pid");
        } else {
            throw new IOException("Java temp directory " + System.getProperty(JAVA_TMP_DIR) + " does not exist.");
        }
        if (pidFile.exists()) {
            throw new IOException("PID file " + pidFile.getCanonicalPath() + " already exists, indicating the service is already running.");
        }
        return pidFile;
    }

    public static Log getLog() {
        return LOG;
    }
}

