/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.jvm.AbstractJVMRecord;
import kieker.common.util.registry.IRegistry;

public class CompilationRecord
extends AbstractJVMRecord {
    public static final int SIZE = 28;
    private static final long serialVersionUID = 3721176153109169920L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, String.class, Long.TYPE};
    private final String jitCompilerName;
    private final long totalCompilationTimeMS;

    public CompilationRecord(long timestamp, String hostname, String vmName, String jitCompilerName, long totalCompilationTimeMS) {
        super(timestamp, hostname, vmName);
        this.jitCompilerName = jitCompilerName == null ? "" : jitCompilerName;
        this.totalCompilationTimeMS = totalCompilationTimeMS;
    }

    public CompilationRecord(Object[] values) {
        super(values, TYPES);
        this.jitCompilerName = (String)values[3];
        this.totalCompilationTimeMS = (Long)values[4];
    }

    protected CompilationRecord(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.jitCompilerName = (String)values[3];
        this.totalCompilationTimeMS = (Long)values[4];
    }

    public CompilationRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.jitCompilerName = stringRegistry.get(buffer.getInt());
        this.totalCompilationTimeMS = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getVmName(), this.getJitCompilerName(), this.getTotalCompilationTimeMS()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getVmName()));
        buffer.putInt(stringRegistry.get(this.getJitCompilerName()));
        buffer.putLong(this.getTotalCompilationTimeMS());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getJitCompilerName() {
        return this.jitCompilerName;
    }

    public final long getTotalCompilationTimeMS() {
        return this.totalCompilationTimeMS;
    }
}

