/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.ICallRecord;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.util.registry.IRegistry;

public class CallOperationEvent
extends AbstractOperationEvent
implements ICallRecord {
    public static final int SIZE = 36;
    private static final long serialVersionUID = -1777034164507512479L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class};
    private final String calleeOperationSignature;
    private final String calleeClassSignature;

    public CallOperationEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String calleeOperationSignature, String calleeClassSignature) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
        this.calleeOperationSignature = calleeOperationSignature == null ? "" : calleeOperationSignature;
        this.calleeClassSignature = calleeClassSignature == null ? "" : calleeClassSignature;
    }

    public CallOperationEvent(Object[] values) {
        super(values, TYPES);
        this.calleeOperationSignature = (String)values[5];
        this.calleeClassSignature = (String)values[6];
    }

    protected CallOperationEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.calleeOperationSignature = (String)values[5];
        this.calleeClassSignature = (String)values[6];
    }

    public CallOperationEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.calleeOperationSignature = stringRegistry.get(buffer.getInt());
        this.calleeClassSignature = stringRegistry.get(buffer.getInt());
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getOperationSignature(), this.getClassSignature(), this.getCalleeOperationSignature(), this.getCalleeClassSignature()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putLong(this.getTraceId());
        buffer.putInt(this.getOrderIndex());
        buffer.putInt(stringRegistry.get(this.getOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getClassSignature()));
        buffer.putInt(stringRegistry.get(this.getCalleeOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getCalleeClassSignature()));
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getCallerOperationSignature() {
        return this.getOperationSignature();
    }

    @Override
    public final String getCallerClassSignature() {
        return this.getClassSignature();
    }

    @Override
    public final String getCalleeOperationSignature() {
        return this.calleeOperationSignature;
    }

    @Override
    public final String getCalleeClassSignature() {
        return this.calleeClassSignature;
    }
}

