/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib;

import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.TimeSeries;
import kieker.tools.tslib.anomalycalculators.IAnomalyScoreCalculator;
import kieker.tools.tslib.anomalycalculators.SimpleAnomalyScoreCalculator;
import kieker.tools.tslib.forecast.IForecaster;
import kieker.tools.tslib.forecast.arima.ARIMA101Forecaster;
import kieker.tools.tslib.forecast.arima.ARIMAForecaster;
import kieker.tools.tslib.forecast.croston.CrostonForecaster;
import kieker.tools.tslib.forecast.cs.CSForecaster;
import kieker.tools.tslib.forecast.ets.ETSForecaster;
import kieker.tools.tslib.forecast.mean.MeanForecaster;
import kieker.tools.tslib.forecast.mean.MeanForecasterJava;
import kieker.tools.tslib.forecast.naive.NaiveForecaster;
import kieker.tools.tslib.forecast.ses.SESRForecaster;

public enum ForecastMethod {
    ARIMA,
    ARIMA101,
    CROSTON,
    CS,
    ETS,
    MEAN,
    MEANJAVA,
    NAIVE,
    SES;


    public IForecaster<Double> getForecaster(ITimeSeries<Double> history) {
        switch (this) {
            case ARIMA: {
                return new ARIMAForecaster(history);
            }
            case ARIMA101: {
                return new ARIMA101Forecaster(history);
            }
            case CROSTON: {
                return new CrostonForecaster(history);
            }
            case CS: {
                return new CSForecaster(history);
            }
            case ETS: {
                return new ETSForecaster(history);
            }
            case MEAN: {
                return new MeanForecaster(history);
            }
            case MEANJAVA: {
                return new MeanForecasterJava(history);
            }
            case NAIVE: {
                return new NaiveForecaster(history);
            }
            case SES: {
                return new SESRForecaster(history);
            }
        }
        throw new IllegalArgumentException("No forecaster defined for " + this.toString());
    }

    public IForecaster<Double> getForecaster(ITimeSeries<Double> history, int alpha) {
        switch (this) {
            case ARIMA: {
                return new ARIMAForecaster(history, alpha);
            }
            case ARIMA101: {
                return new ARIMA101Forecaster(history, alpha);
            }
            case CROSTON: {
                return new CrostonForecaster(history, alpha);
            }
            case CS: {
                return new CSForecaster(ForecastMethod.getLastXofTS(history, 30), alpha);
            }
            case ETS: {
                return new ETSForecaster(history, alpha);
            }
            case MEAN: {
                return new MeanForecaster(ForecastMethod.getLastXofTS(history, 10), alpha);
            }
            case MEANJAVA: {
                return new MeanForecasterJava(ForecastMethod.getLastXofTS(history, 10));
            }
            case NAIVE: {
                return new NaiveForecaster(history, alpha);
            }
            case SES: {
                return new SESRForecaster(history, alpha);
            }
        }
        throw new IllegalArgumentException("No forecaster defined for " + this.toString());
    }

    public IAnomalyScoreCalculator<Double> getAnomalyScoreCalculator() {
        return new SimpleAnomalyScoreCalculator();
    }

    private static ITimeSeries<Double> getLastXofTS(ITimeSeries<Double> ts, int x) {
        if (ts.size() >= x) {
            Double[] a = new Double[ts.size()];
            a = ts.getValues().toArray(a);
            Double[] b = new Double[x];
            for (int i = 0; i < x; ++i) {
                b[i] = a[ts.size() - x + i];
            }
            long newStartTime = ts.getStartTime();
            TimeSeries<Double> tsLastX = new TimeSeries<Double>(newStartTime += (long)(ts.size() - x) * ts.getDeltaTimeUnit().toMillis(ts.getDeltaTime()), ts.getTimeSeriesTimeUnit(), ts.getDeltaTime(), ts.getDeltaTimeUnit(), ts.getCapacity());
            tsLastX.appendAll(b);
            return tsLastX;
        }
        return ts;
    }
}

