/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.common.util.signature.Signature;
import kieker.tools.traceAnalysis.systemModel.ComponentType;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.repository.AbstractSystemSubRepository;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.repository.TypeRepository;

public class OperationRepository
extends AbstractSystemSubRepository {
    public static final Signature ROOT_SIGNATURE = new Signature("'Entry'", new String[0], "<>", new String[0]);
    public static final Operation ROOT_OPERATION = new Operation(0, TypeRepository.ROOT_COMPONENT, ROOT_SIGNATURE);
    private final Map<String, Operation> operationsByName = new Hashtable<String, Operation>();
    private final Map<Integer, Operation> operationsById = new Hashtable<Integer, Operation>();

    public OperationRepository(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final Operation lookupOperationByNamedIdentifier(String namedIdentifier) {
        return this.operationsByName.get(namedIdentifier);
    }

    public final Operation createAndRegisterOperation(String namedIdentifier, ComponentType componentType, Signature signature) {
        if (this.operationsByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        Operation newInst = new Operation(id, componentType, signature);
        this.operationsById.put(id, newInst);
        this.operationsByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<Operation> getOperations() {
        return this.operationsById.values();
    }
}

