/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.gui.AbstractStep;

public class ConversionStep
extends AbstractStep {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_KEY_IDENTIFIER = ConversionStep.class.getSimpleName();
    private static final String PROPERTY_KEY_PERFORM_STEP = PROPERTY_KEY_IDENTIFIER + ".performStep";
    private static final String PROPERTY_KEY_GRAPHVIZ = PROPERTY_KEY_IDENTIFIER + ".graphvizDirectoryField";
    private static final String PROPERTY_KEY_PIC2PLOT = PROPERTY_KEY_IDENTIFIER + ".pic2plotDirectoryField";
    private static final String PROPERTY_KEY_OUTPUT_FORMAT = PROPERTY_KEY_IDENTIFIER + ".outputFormatField";
    private static final Log LOG = LogFactory.getLog(ConversionStep.class);
    private final String currentPath = new File(".").getAbsolutePath();
    private final JLabel infoLabel = new JLabel("<html>In this step you manage Graphviz and Pic2Plot in order to convert the results from the trace analysis.<br/><br/>WARNING: If selected, this step will overwrite existing files in your output directory.</html>");
    private final JPanel expandingPanel1 = new JPanel();
    private final JPanel expandingPanel2 = new JPanel();
    private final JCheckBox performStep = new JCheckBox("Perform File Conversion");
    private final JLabel graphvizDirectoryLabel = new JLabel("Graphviz Directory: ");
    private final JLabel pic2plotDirectoryLabel = new JLabel("Pic2Plot Directory: ");
    private final JTextField graphvizDirectoryField = new JTextField(this.currentPath);
    private final JTextField pic2plotDirectoryField = new JTextField(this.currentPath);
    private final JButton graphvizDirectoryChooseButton = new JButton("Choose");
    private final JButton pic2plotDirectoryChooseButton = new JButton("Choose");
    private final JLabel outputFormat = new JLabel("Output Format: ");
    private final JComboBox outputFormatField = new JComboBox<String>(new String[]{"PNG", "JPEG", "SVG", "PDF"});

    public ConversionStep() {
        this.addAndLayoutComponents();
        this.addLogicToComponents();
    }

    private void addAndLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.infoLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(5, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.performStep, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.graphvizDirectoryLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.graphvizDirectoryField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.graphvizDirectoryChooseButton, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.add((Component)this.pic2plotDirectoryLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pic2plotDirectoryField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        this.add((Component)this.pic2plotDirectoryChooseButton, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.outputFormat, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.outputFormatField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.expandingPanel1, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.expandingPanel2, gridBagConstraints);
    }

    private void addLogicToComponents() {
        this.graphvizDirectoryChooseButton.addActionListener(new ChooseDirectoryActionListener(this.graphvizDirectoryField, this));
        this.pic2plotDirectoryChooseButton.addActionListener(new ChooseDirectoryActionListener(this.pic2plotDirectoryField, this));
        this.performStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConversionStep.this.graphvizDirectoryField.setEnabled(ConversionStep.this.performStep.isSelected());
                ConversionStep.this.pic2plotDirectoryField.setEnabled(ConversionStep.this.performStep.isSelected());
                ConversionStep.this.graphvizDirectoryChooseButton.setEnabled(ConversionStep.this.performStep.isSelected());
                ConversionStep.this.pic2plotDirectoryChooseButton.setEnabled(ConversionStep.this.performStep.isSelected());
                ConversionStep.this.outputFormatField.setEnabled(ConversionStep.this.performStep.isSelected());
            }
        });
    }

    @Override
    public void addSelectedTraceAnalysisParameters(Collection<String> parameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String outputDirectory) {
        if (this.performStep.isSelected()) {
            File outputDir = new File(outputDirectory);
            File[] dotFiles = outputDir.listFiles(new FileNameExtensionFilter(".dot"));
            File[] picFiles = outputDir.listFiles(new FileNameExtensionFilter(".pic"));
            for (File dotFile : dotFiles) {
                try {
                    Process p = Runtime.getRuntime().exec(new String[]{this.graphvizDirectoryField.getText() + "/dot", "-O", "-T" + this.outputFormatField.getSelectedItem().toString().toLowerCase(Locale.ENGLISH), dotFile.getAbsolutePath()});
                    p.waitFor();
                }
                catch (IOException e) {
                    LOG.warn("An exception occurred", e);
                }
                catch (InterruptedException e) {
                    LOG.warn("An exception occurred", e);
                }
            }
            for (File picFile : picFiles) {
                OutputStream writer = null;
                try {
                    int r;
                    Process p = Runtime.getRuntime().exec(new String[]{this.pic2plotDirectoryField.getText() + "/pic2plot", "-T" + this.outputFormatField.getSelectedItem().toString().toLowerCase(Locale.ENGLISH), picFile.getAbsolutePath()});
                    InputStream s = p.getInputStream();
                    writer = new FileOutputStream(picFile.getAbsolutePath() + "." + this.outputFormatField.getSelectedItem().toString().toLowerCase(Locale.ENGLISH));
                    byte[] buffer = new byte[10240];
                    while ((r = s.read(buffer)) != -1) {
                        writer.write(buffer, 0, r);
                    }
                    writer.close();
                    s.close();
                    p.waitFor();
                }
                catch (IOException e) {
                    LOG.warn("An exception occurred", e);
                }
                catch (InterruptedException e) {
                    LOG.warn("An exception occurred", e);
                }
                finally {
                    if (null != writer) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            LOG.warn("An exception occurred", e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void loadDefaultConfiguration() {
        this.graphvizDirectoryField.setText(this.currentPath);
        this.pic2plotDirectoryField.setText(this.currentPath);
        this.outputFormatField.setSelectedIndex(0);
        this.graphvizDirectoryField.setEnabled(false);
        this.pic2plotDirectoryField.setEnabled(false);
        this.graphvizDirectoryChooseButton.setEnabled(false);
        this.pic2plotDirectoryChooseButton.setEnabled(false);
        this.outputFormatField.setEnabled(false);
    }

    @Override
    public void saveCurrentConfiguration(Properties properties) {
        properties.setProperty(PROPERTY_KEY_PERFORM_STEP, Boolean.toString(this.performStep.isSelected()));
        properties.setProperty(PROPERTY_KEY_GRAPHVIZ, this.graphvizDirectoryField.getText());
        properties.setProperty(PROPERTY_KEY_PIC2PLOT, this.pic2plotDirectoryField.getText());
        properties.setProperty(PROPERTY_KEY_OUTPUT_FORMAT, Integer.toString(this.outputFormatField.getSelectedIndex()));
    }

    @Override
    public void loadCurrentConfiguration(Properties properties) {
        this.performStep.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_PERFORM_STEP)));
        this.graphvizDirectoryField.setText(properties.getProperty(PROPERTY_KEY_GRAPHVIZ));
        this.pic2plotDirectoryField.setText(properties.getProperty(PROPERTY_KEY_PIC2PLOT));
        this.outputFormatField.setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_KEY_OUTPUT_FORMAT)));
        this.graphvizDirectoryField.setEnabled(this.performStep.isSelected());
        this.pic2plotDirectoryField.setEnabled(this.performStep.isSelected());
        this.graphvizDirectoryChooseButton.setEnabled(this.performStep.isSelected());
        this.pic2plotDirectoryChooseButton.setEnabled(this.performStep.isSelected());
        this.outputFormatField.setEnabled(this.performStep.isSelected());
    }

    @Override
    public boolean isNextStepAllowed() {
        boolean performThisStep = this.performStep.isSelected();
        if (performThisStep) {
            int result;
            boolean graphvizAvailable = this.checkGraphvizExecutable();
            if (!graphvizAvailable && 1 == (result = JOptionPane.showConfirmDialog(this, "The Graphviz executable could not be found. Continue?", "Graphviz Executable", 0, 2))) {
                return false;
            }
            boolean pic2PlotAvailable = this.checkPic2PlotExecutable();
            if (!pic2PlotAvailable) {
                int result2 = JOptionPane.showConfirmDialog(this, "The Pic2Plot executable could not be found. Continue?", "Pic2Plot Executable", 0, 2);
                return 0 == result2;
            }
        }
        return true;
    }

    private boolean checkPic2PlotExecutable() {
        return this.checkExecutable(this.pic2plotDirectoryField.getText() + "/pic2plot", "--v");
    }

    private boolean checkGraphvizExecutable() {
        return this.checkExecutable(this.graphvizDirectoryField.getText() + "/dot", "-V");
    }

    private boolean checkExecutable(String command, String parameter) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{command, parameter});
            return 0 == p.waitFor();
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static class FileNameExtensionFilter
    implements FilenameFilter {
        private final String extension;

        public FileNameExtensionFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }

    private static class ChooseDirectoryActionListener
    implements ActionListener {
        private final JTextField textField;
        private final Component parent;

        public ChooseDirectoryActionListener(JTextField textField, Component parent) {
            this.textField = textField;
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser = new JFileChooser(this.textField.getText());
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showOpenDialog(this.parent) == 0) {
                this.textField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

