/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.flow;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.flow.TraceEventRecords;
import kieker.common.configuration.Configuration;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.tools.traceAnalysis.filter.AbstractTraceProcessingFilter;

@Plugin(description="Counts and reports the number of incoming valid/invalid event record traces", configuration={@Property(name="logInvalidTraces", defaultValue="true")})
public class EventRecordTraceCounter
extends AbstractTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_VALID = "validEventRecordTraces";
    public static final String INPUT_PORT_NAME_INVALID = "invalidEventRecordTraces";
    public static final String CONFIG_PROPERTY_NAME_LOG_INVALID = "logInvalidTraces";
    private static final long TRACE_ID_IF_NONE = -1L;
    private final boolean logInvalidTraces;

    public EventRecordTraceCounter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.logInvalidTraces = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_LOG_INVALID);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration config = super.getCurrentConfiguration();
        config.setProperty(CONFIG_PROPERTY_NAME_LOG_INVALID, Boolean.toString(this.logInvalidTraces));
        return config;
    }

    @InputPort(name="validEventRecordTraces", eventTypes={TraceEventRecords.class}, description="Receives valid event record traces")
    public void inputValidTrace(TraceEventRecords validTrace) {
        super.reportSuccess(validTrace.getTraceMetadata().getTraceId());
    }

    @InputPort(name="invalidEventRecordTraces", eventTypes={TraceEventRecords.class}, description="Receives invalid event record traces")
    public void inputInvalidTrace(TraceEventRecords invalidTrace) {
        TraceMetadata trace;
        if (this.logInvalidTraces) {
            this.log.error("Invalid trace: " + invalidTrace);
        }
        if ((trace = invalidTrace.getTraceMetadata()) != null) {
            super.reportError(invalidTrace.getTraceMetadata().getTraceId());
        } else {
            AbstractTraceEvent[] events = invalidTrace.getTraceEvents();
            if (events != null && events.length > 0) {
                super.reportError(events[0].getTraceId());
            } else {
                super.reportError(-1L);
            }
        }
    }
}

