/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.record;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class AggregationWindow
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 16;
    private static final long serialVersionUID = 3008527186261564671L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE};
    private final long windowStart;
    private final long windowEnd;

    public AggregationWindow(long windowStart, long windowEnd) {
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
    }

    public AggregationWindow(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.windowStart = (Long)values[0];
        this.windowEnd = (Long)values[1];
    }

    protected AggregationWindow(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.windowStart = (Long)values[0];
        this.windowEnd = (Long)values[1];
    }

    public AggregationWindow(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.windowStart = buffer.getLong();
        this.windowEnd = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getWindowStart(), this.getWindowEnd()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getWindowStart());
        buffer.putLong(this.getWindowEnd());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getWindowStart() {
        return this.windowStart;
    }

    public final long getWindowEnd() {
        return this.windowEnd;
    }
}

