/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.tools.opad.record.NamedDoubleRecord;

@Plugin(description="Converts OperationExecutionRecords to NamedDoubleRecords", outputPorts={@OutputPort(name="ndr", eventTypes={NamedDoubleRecord.class})})
public class RecordConverter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_OER = "oer";
    public static final String OUTPUT_PORT_NAME_NDR = "ndr";

    public RecordConverter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    @InputPort(name="oer", eventTypes={OperationExecutionRecord.class})
    public void convert(OperationExecutionRecord oer) {
        long timestamp = oer.getLoggingTimestamp();
        String application = oer.getHostname() + ":" + oer.getOperationSignature();
        double response = oer.getTout() - oer.getTin();
        if (response >= 0.0) {
            NamedDoubleRecord ndr = new NamedDoubleRecord(application, timestamp, response);
            super.deliver(OUTPUT_PORT_NAME_NDR, ndr);
        }
    }
}

