/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import java.util.concurrent.atomic.AtomicReference;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.AbstractUpdateableFilterPlugin;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.record.ExtendedStorableDetectionResult;
import kieker.tools.opad.record.StorableDetectionResult;

@Plugin(name="AnomalyScore Detection Filter", outputPorts={@OutputPort(eventTypes={StorableDetectionResult.class}, name="anomalyscore_anomaly"), @OutputPort(eventTypes={StorableDetectionResult.class}, name="anomalyscore_else"), @OutputPort(eventTypes={ExtendedStorableDetectionResult.class}, name="allOutputData")}, configuration={@Property(name="threshold", defaultValue="0.5", updateable=true)})
public class AnomalyDetectionFilter
extends AbstractUpdateableFilterPlugin {
    public static final String INPUT_PORT_ANOMALY_SCORE = "anomalyscore";
    public static final String OUTPUT_PORT_ANOMALY_SCORE_IF_ANOMALY = "anomalyscore_anomaly";
    public static final String OUTPUT_PORT_ANOMALY_SCORE_ELSE = "anomalyscore_else";
    public static final String OUTPUT_PORT_ALL = "allOutputData";
    public static final String CONFIG_PROPERTY_NAME_THRESHOLD = "threshold";
    private AtomicReference<Double> threshold;

    public AnomalyDetectionFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        String sThreshold = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_THRESHOLD);
        this.threshold = new AtomicReference<Double>(Double.parseDouble(sThreshold));
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration config = new Configuration();
        config.setProperty(CONFIG_PROPERTY_NAME_THRESHOLD, Double.toString(this.threshold.get()));
        return config;
    }

    @InputPort(eventTypes={StorableDetectionResult.class}, name="anomalyscore")
    public void inputForecastAndMeasurement(StorableDetectionResult anomalyScore) {
        if (anomalyScore.getScore() >= this.threshold.get()) {
            super.deliver(OUTPUT_PORT_ANOMALY_SCORE_IF_ANOMALY, anomalyScore);
        } else {
            super.deliver(OUTPUT_PORT_ANOMALY_SCORE_ELSE, anomalyScore);
        }
        ExtendedStorableDetectionResult extAnomalyScore = new ExtendedStorableDetectionResult(anomalyScore.getApplicationName(), anomalyScore.getValue(), anomalyScore.getTimestamp(), anomalyScore.getForecast(), anomalyScore.getScore(), this.threshold.get());
        super.deliver(OUTPUT_PORT_ALL, extAnomalyScore);
    }

    @Override
    public void setCurrentConfiguration(Configuration config, boolean update) {
        if (!update || this.isPropertyUpdateable(CONFIG_PROPERTY_NAME_THRESHOLD)) {
            this.threshold = new AtomicReference<Double>(Double.parseDouble(config.getStringProperty(CONFIG_PROPERTY_NAME_THRESHOLD)));
        }
    }
}

