/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public final class FsWriterThread
extends AbstractFsWriterThread {
    private static final String ENCODING = "UTF-8";
    private PrintWriter pos = null;
    private final boolean autoflush;
    private final int bufferSize;

    public FsWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int maxLogSize, int maxLogFiles, boolean autoflush, int bufferSize) {
        super(monitoringController, writeQueue, mappingFileWriter, path, maxEntriesInFile, maxLogSize, maxLogFiles);
        this.autoflush = autoflush;
        this.bufferSize = bufferSize;
    }

    @Override
    protected final void write(IMonitoringRecord monitoringRecord) throws IOException {
        Object[] recordFields = monitoringRecord.toArray();
        StringBuilder sb = new StringBuilder(256);
        sb.append('$');
        sb.append(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
        sb.append(';');
        sb.append(monitoringRecord.getLoggingTimestamp());
        for (Object recordField : recordFields) {
            sb.append(';');
            sb.append(String.valueOf(recordField));
        }
        this.pos.println(sb.toString());
    }

    @Override
    protected final void prepareFile(String filename) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.pos != null) {
            this.pos.close();
        }
        this.pos = this.autoflush ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), ENCODING), true) : new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), ENCODING), this.bufferSize), false);
        this.pos.flush();
    }

    @Override
    protected final void cleanup() {
        if (this.pos != null) {
            this.pos.close();
        }
    }
}

