/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.async.AbstractZipWriterThread;
import kieker.monitoring.writer.filesystem.map.StringMappingFileWriter;

public class AsciiZipWriterThread
extends AbstractZipWriterThread {
    private final PrintWriter out;

    public AsciiZipWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, StringMappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int bufferSize, int level) throws IOException {
        super(monitoringController, writeQueue, mappingFileWriter, path, maxEntriesInFile, level);
        this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8"), bufferSize), false);
    }

    @Override
    protected void write(IMonitoringRecord monitoringRecord) throws IOException {
        Object[] recordFields = monitoringRecord.toArray();
        StringBuilder sb = new StringBuilder(256);
        sb.append('$');
        sb.append(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
        sb.append(';');
        sb.append(monitoringRecord.getLoggingTimestamp());
        for (Object recordField : recordFields) {
            sb.append(';');
            sb.append(String.valueOf(recordField));
        }
        this.out.println(sb.toString());
    }

    @Override
    protected void cleanupForNextEntry() throws IOException {
        this.out.flush();
    }

    @Override
    protected void cleanupFinal() throws IOException {
        this.out.close();
    }
}

