/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.File;
import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.filesystem.async.AbstractZipWriterThread;
import kieker.monitoring.writer.filesystem.map.StringMappingFileWriter;

public abstract class AbstractAsyncZipWriter
extends AbstractAsyncWriter {
    public static final String CONFIG_PATH = "customStoragePath";
    public static final String CONFIG_MAXENTRIESINFILE = "maxEntriesInFile";
    public static final String CONFIG_BUFFER = "bufferSize";
    public static final String CONFIG_COMPRESS_LEVEL = "compressionLevel";
    private static final String CONFIG_TEMP = "storeInJavaIoTmpdir";
    private static final Log LOG = LogFactory.getLog(AbstractAsyncZipWriter.class);
    private final StringMappingFileWriter mappingFileWriter = new StringMappingFileWriter();
    private final String configPath;
    private final int configMaxEntriesInFile;
    private final int configBuffersize;
    private final int configLevel;

    public AbstractAsyncZipWriter(Configuration configuration) {
        super(configuration);
        String tmpPath;
        String prefix = this.getClass().getName() + '.';
        if (configuration.getBooleanProperty(prefix + CONFIG_TEMP)) {
            LogFactory.getLog(this.getClass()).warn("Using deprecated configuration property " + prefix + CONFIG_TEMP + ". Instead use empty value for " + prefix + CONFIG_PATH);
        }
        if ((tmpPath = configuration.getStringProperty(prefix + CONFIG_PATH)).length() == 0) {
            tmpPath = System.getProperty("java.io.tmpdir");
        }
        if (!new File(tmpPath).isDirectory()) {
            throw new IllegalArgumentException("'" + tmpPath + "' is not a directory.");
        }
        this.configPath = tmpPath;
        this.configMaxEntriesInFile = configuration.getIntProperty(prefix + CONFIG_MAXENTRIESINFILE);
        if (this.configMaxEntriesInFile < 1) {
            throw new IllegalArgumentException(prefix + CONFIG_MAXENTRIESINFILE + " must be greater than 0 but is '" + this.configMaxEntriesInFile + "'");
        }
        int tmpBuffersize = configuration.getIntProperty(prefix + CONFIG_BUFFER);
        if (tmpBuffersize <= 0) {
            LOG.warn("Buffer size has to be greater than zero. Using 8192 instead.");
            tmpBuffersize = 8192;
        }
        this.configBuffersize = tmpBuffersize;
        int tmpLevel = configuration.getIntProperty(prefix + CONFIG_COMPRESS_LEVEL);
        if (tmpLevel != -1 && tmpLevel != 0 && (tmpLevel < 1 || tmpLevel > 9)) {
            LOG.warn("Illegal compression level. Using default compression level instead.");
            tmpLevel = -1;
        }
        this.configLevel = tmpLevel;
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        String prefix = this.getClass().getName() + ".";
        configuration.setProperty(prefix + CONFIG_PATH, "");
        configuration.setProperty(prefix + CONFIG_MAXENTRIESINFILE, "25000");
        configuration.setProperty(prefix + CONFIG_BUFFER, "8192");
        configuration.setProperty(prefix + CONFIG_COMPRESS_LEVEL, Integer.toString(-1));
        return configuration;
    }

    @Override
    protected final void init() throws Exception {
        this.addWorker(this.initWorker(this.monitoringController, this.blockingQueue, this.mappingFileWriter, this.configPath, this.configMaxEntriesInFile, this.configBuffersize, this.configLevel));
        this.addWorker(this.initWorker(this.monitoringController, this.prioritizedBlockingQueue, this.mappingFileWriter, this.configPath, this.configMaxEntriesInFile, this.configBuffersize, this.configLevel));
    }

    protected abstract AbstractZipWriterThread initWorker(IMonitoringController var1, BlockingQueue<IMonitoringRecord> var2, StringMappingFileWriter var3, String var4, int var5, int var6, int var7) throws Exception;
}

