/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.spring.executions;

import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class OperationExecutionMethodInvocationInterceptor
implements MethodInterceptor,
IMonitoringProbe {
    private static final Log LOG = LogFactory.getLog(OperationExecutionMethodInvocationInterceptor.class);
    private static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    private static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    private final IMonitoringController monitoringCtrl;
    private final ITimeSource timeSource;
    private final String hostname;

    public OperationExecutionMethodInvocationInterceptor() {
        this(MonitoringController.getInstance());
    }

    public OperationExecutionMethodInvocationInterceptor(IMonitoringController monitoringController) {
        this.monitoringCtrl = monitoringController;
        this.timeSource = this.monitoringCtrl.getTimeSource();
        this.hostname = this.monitoringCtrl.getHostname();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retval;
        int ess;
        int eoi;
        boolean entrypoint;
        if (!this.monitoringCtrl.isMonitoringEnabled()) {
            return invocation.proceed();
        }
        String signature = invocation.getMethod().toString();
        if (!this.monitoringCtrl.isProbeActivated(signature)) {
            return invocation.proceed();
        }
        String sessionId = SESSION_REGISTRY.recallThreadLocalSessionId();
        long traceId = CF_REGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            entrypoint = true;
            traceId = CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
            CF_REGISTRY.storeThreadLocalEOI(0);
            CF_REGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
        } else {
            entrypoint = false;
            eoi = CF_REGISTRY.incrementAndRecallThreadLocalEOI();
            ess = CF_REGISTRY.recallAndIncrementThreadLocalESS();
            if (eoi == -1 || ess == -1) {
                LOG.error("eoi and/or ess have invalid values: eoi == " + eoi + " ess == " + ess);
                this.monitoringCtrl.terminateMonitoring();
            }
        }
        long tin = this.timeSource.getTime();
        try {
            retval = invocation.proceed();
        }
        finally {
            long tout = this.timeSource.getTime();
            this.monitoringCtrl.newMonitoringRecord(new OperationExecutionRecord(signature, sessionId, traceId, tin, tout, this.hostname, eoi, ess));
            if (entrypoint) {
                CF_REGISTRY.unsetThreadLocalTraceId();
                CF_REGISTRY.unsetThreadLocalEOI();
                CF_REGISTRY.unsetThreadLocalESS();
            } else {
                CF_REGISTRY.storeThreadLocalESS(ess);
            }
        }
        return retval;
    }
}

