/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.sink;

import kieker.analysis.IProjectContext;
import kieker.analysis.display.TagCloud;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.signature.ClassOperationSignaturePair;

@Plugin
public class MethodAndComponentFlowDisplayFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    private final TagCloud methodTagCloud = new TagCloud();
    private final TagCloud componentTagCloud = new TagCloud();

    public MethodAndComponentFlowDisplayFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @InputPort(name="inputEvents", eventTypes={OperationExecutionRecord.class})
    public void input(OperationExecutionRecord record) {
        String shortClassName = ClassOperationSignaturePair.splitOperationSignatureStr(record.getOperationSignature()).getSimpleClassname();
        String methodName = shortClassName + '.' + this.extractMethodName(record.getOperationSignature());
        this.methodTagCloud.incrementCounter(methodName);
        this.componentTagCloud.incrementCounter(shortClassName);
    }

    private String extractMethodName(String operationSignature) {
        String operationSignatureWithoutParameters = operationSignature.replaceAll("\\(.*\\)", "");
        int lastPointPos = operationSignatureWithoutParameters.lastIndexOf(46);
        String methodName = operationSignatureWithoutParameters.substring(lastPointPos + 1);
        return methodName;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    @Display(name="Method Tag Cloud Display")
    public TagCloud methodTagCloudDisplay() {
        return this.methodTagCloud;
    }

    @Display(name="Component Tag Cloud Display")
    public TagCloud componentTagCloudDisplay() {
        return this.componentTagCloud;
    }
}

