/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CustomX509TrustManager
implements X509TrustManager {
    private final X509TrustManager defaultTrustManager;
    private static final Logger log = LoggingManager.getLoggerForClass();

    public CustomX509TrustManager(X509TrustManager defaultTrustManager) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = defaultTrustManager;
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && log.isDebugEnabled()) {
            for (int c = 0; c < certificates.length; ++c) {
                X509Certificate cert = certificates[c];
                log.debug(" Client certificate " + (c + 1) + ":");
                log.debug("  Subject DN: " + cert.getSubjectDN());
                log.debug("  Signature Algorithm: " + cert.getSigAlgName());
                log.debug("  Valid from: " + cert.getNotBefore());
                log.debug("  Valid until: " + cert.getNotAfter());
                log.debug("  Issuer: " + cert.getIssuerDN());
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && log.isDebugEnabled()) {
            for (int c = 0; c < certificates.length; ++c) {
                X509Certificate cert = certificates[c];
                log.debug(" Server certificate " + (c + 1) + ":");
                log.debug("  Subject DN: " + cert.getSubjectDN());
                log.debug("  Signature Algorithm: " + cert.getSigAlgName());
                log.debug("  Valid from: " + cert.getNotBefore());
                log.debug("  Valid until: " + cert.getNotAfter());
                log.debug("  Issuer: " + cert.getIssuerDN());
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

