/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.reporters.ResultSaver;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apache.jorphan.gui.JLabeledTextField;

public class ResultSaverGui
extends AbstractListenerGui
implements Clearable {
    private static final long serialVersionUID = 240L;
    private JTextField filename;
    private JTextField variableName;
    private JCheckBox errorsOnly;
    private JCheckBox successOnly;
    private JCheckBox skipAutoNumber;
    private JCheckBox skipSuffix;
    private JCheckBox addTimestamp;
    private JLabeledTextField numberPadLength;

    public ResultSaverGui() {
        this.init();
    }

    public String getLabelResource() {
        return "resultsaver_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.filename.setText(el.getPropertyAsString("FileSaver.filename"));
        this.errorsOnly.setSelected(el.getPropertyAsBoolean("FileSaver.errorsonly"));
        this.successOnly.setSelected(el.getPropertyAsBoolean("FileSaver.successonly"));
        this.skipAutoNumber.setSelected(el.getPropertyAsBoolean("FileSaver.skipautonumber"));
        this.skipSuffix.setSelected(el.getPropertyAsBoolean("FileSaver.skipsuffix"));
        this.variableName.setText(el.getPropertyAsString("FileSaver.variablename", ""));
        this.addTimestamp.setSelected(el.getPropertyAsBoolean("FileSaver.addTimstamp"));
        this.numberPadLength.setText(el.getPropertyAsString("FileSaver.numberPadLen", ""));
    }

    public TestElement createTestElement() {
        ResultSaver resultSaver = new ResultSaver();
        this.modifyTestElement(resultSaver);
        return resultSaver;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        te.setProperty("FileSaver.filename", this.filename.getText());
        te.setProperty("FileSaver.errorsonly", this.errorsOnly.isSelected());
        te.setProperty("FileSaver.skipautonumber", this.skipAutoNumber.isSelected());
        te.setProperty("FileSaver.skipsuffix", this.skipSuffix.isSelected());
        te.setProperty("FileSaver.successonly", this.successOnly.isSelected());
        te.setProperty("FileSaver.addTimstamp", this.addTimestamp.isSelected(), false);
        AbstractTestElement at = (AbstractTestElement)te;
        at.setProperty("FileSaver.variablename", this.variableName.getText(), "");
        at.setProperty("FileSaver.numberPadLen", this.numberPadLength.getText(), "");
    }

    public void clearGui() {
        super.clearGui();
        this.skipAutoNumber.setSelected(false);
        this.skipSuffix.setSelected(false);
        this.filename.setText("");
        this.errorsOnly.setSelected(false);
        this.successOnly.setSelected(false);
        this.addTimestamp.setSelected(false);
        this.variableName.setText("");
        this.numberPadLength.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createFilenamePrefixPanel());
        box.add(this.createVariableNamePanel());
        this.errorsOnly = new JCheckBox(JMeterUtils.getResString("resultsaver_errors"));
        box.add(this.errorsOnly);
        this.successOnly = new JCheckBox(JMeterUtils.getResString("resultsaver_success"));
        box.add(this.successOnly);
        this.skipAutoNumber = new JCheckBox(JMeterUtils.getResString("resultsaver_skipautonumber"));
        box.add(this.skipAutoNumber);
        this.skipSuffix = new JCheckBox(JMeterUtils.getResString("resultsaver_skipsuffix"));
        box.add(this.skipSuffix);
        this.addTimestamp = new JCheckBox(JMeterUtils.getResString("resultsaver_addtimestamp"));
        box.add(this.addTimestamp);
        this.numberPadLength = new JLabeledTextField(JMeterUtils.getResString("resultsaver_numberpadlen"));
        box.add((Component)this.numberPadLength);
        this.add((Component)box, "North");
    }

    private JPanel createFilenamePrefixPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString("resultsaver_prefix"));
        this.filename = new JTextField(10);
        this.filename.setName("FileSaver.filename");
        label.setLabelFor(this.filename);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private JPanel createVariableNamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString("resultsaver_variable"));
        this.variableName = new JTextField(10);
        this.variableName.setName("FileSaver.variablename");
        label.setLabelFor(this.variableName);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.variableName, "Center");
        return filenamePanel;
    }

    public void clearData() {
    }
}

