/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveGraphicsService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveGraphics
implements Command {
    private static final Set<String> commands = new HashSet<String>();
    private static final String[] extensions;

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        JComponent comp;
        JMeterGUIComponent component;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        if (e.getActionCommand().equals("save_graphics") && (component = GuiPackage.getInstance().getCurrentGui()) instanceof Printable) {
            comp = ((Printable)((Object)component)).getPrintableComponent();
            this.saveImage(comp);
        }
        if (e.getActionCommand().equals("save_graphics_all")) {
            component = GuiPackage.getInstance().getCurrentGui();
            comp = ((JComponent)((Object)component)).getRootPane();
            this.saveImage(comp);
        }
    }

    private void saveImage(JComponent comp) {
        JFileChooser chooser = FileDialoger.promptToSaveFile(GuiPackage.getInstance().getTreeListener().getCurrentNode().getName(), extensions);
        if (chooser == null) {
            return;
        }
        String filename = chooser.getSelectedFile().getAbsolutePath();
        if (filename != null) {
            int response;
            File f = new File(filename);
            if (f.exists() && ((response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("save_overwrite_existing_file"), JMeterUtils.getResString("save?"), 0, 3)) == -1 || response == 1)) {
                return;
            }
            SaveGraphicsService save = new SaveGraphicsService();
            String ext = filename.substring(filename.length() - 4);
            String name = filename.substring(0, filename.length() - 4);
            if (ext.equals(".png")) {
                save.saveJComponent(name, 0, comp);
            } else if (ext.equals(".tif")) {
                save.saveJComponent(name, 1, comp);
            } else {
                save.saveJComponent(filename, 0, comp);
            }
        }
    }

    static {
        commands.add("save_graphics");
        commands.add("save_graphics_all");
        extensions = new String[]{".tif", ".png"};
    }
}

