/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.Searcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawTextSearcher
implements Searcher {
    private boolean caseSensitive;
    private String textToSearch;

    public RawTextSearcher(boolean caseSensitive, String textToSearch) {
        this.caseSensitive = caseSensitive;
        this.textToSearch = caseSensitive ? textToSearch : textToSearch.toLowerCase();
    }

    @Override
    public boolean search(List<String> textTokens) {
        boolean result = false;
        for (String searchableToken : textTokens) {
            if (StringUtils.isEmpty((CharSequence)searchableToken)) continue;
            if (this.caseSensitive) {
                result = searchableToken.indexOf(this.textToSearch) >= 0;
            } else {
                boolean bl = result = searchableToken.toLowerCase().indexOf(this.textToSearch) >= 0;
            }
            if (!result) continue;
            return result;
        }
        return false;
    }

    protected boolean testField(String value, String searchedTextLowerCase) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value.toLowerCase().indexOf(searchedTextLowerCase) >= 0;
        }
        return false;
    }
}

