/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Copy
extends AbstractAction {
    private static JMeterTreeNode copiedNode = null;
    private static JMeterTreeNode[] copiedNodes = null;
    private static final HashSet<String> commands = new HashSet();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
        JMeterTreeNode[] nodes = treeListener.getSelectedNodes();
        Copy.setCopiedNodes(nodes);
    }

    public static JMeterTreeNode[] getCopiedNodes() {
        if (copiedNodes == null) {
            return null;
        }
        for (int i = 0; i < copiedNodes.length; ++i) {
            if (copiedNodes[i] != null) continue;
            return null;
        }
        return Copy.cloneTreeNodes(copiedNodes);
    }

    public static JMeterTreeNode getCopiedNode() {
        if (copiedNode == null) {
            return null;
        }
        return Copy.cloneTreeNode(copiedNode);
    }

    public static void setCopiedNode(JMeterTreeNode node) {
        copiedNode = Copy.cloneTreeNode(node);
    }

    public static JMeterTreeNode cloneTreeNode(JMeterTreeNode node) {
        JMeterTreeNode treeNode = (JMeterTreeNode)node.clone();
        treeNode.setUserObject(((TestElement)node.getUserObject()).clone());
        Copy.cloneChildren(treeNode, node);
        return treeNode;
    }

    public static void setCopiedNodes(JMeterTreeNode[] nodes) {
        copiedNodes = new JMeterTreeNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Copy.copiedNodes[i] = Copy.cloneTreeNode(nodes[i]);
        }
    }

    public static JMeterTreeNode[] cloneTreeNodes(JMeterTreeNode[] nodes) {
        JMeterTreeNode[] treeNodes = new JMeterTreeNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            treeNodes[i] = Copy.cloneTreeNode(nodes[i]);
        }
        return treeNodes;
    }

    private static void cloneChildren(JMeterTreeNode to, JMeterTreeNode from) {
        Enumeration<JMeterTreeNode> enumFrom = from.children();
        while (enumFrom.hasMoreElements()) {
            JMeterTreeNode child = enumFrom.nextElement();
            JMeterTreeNode childClone = (JMeterTreeNode)child.clone();
            childClone.setUserObject(((TestElement)child.getUserObject()).clone());
            to.add(childClone);
            Copy.cloneChildren((JMeterTreeNode)to.getLastChild(), child);
        }
    }

    static {
        commands.add("Copy");
    }
}

