/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

public class SavePropertyDialog
extends JDialog
implements ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    private static final Map<String, Functor> functors = new HashMap<String, Functor>();
    private static final String NAME_SAVE_PFX = "save";
    private static final String NAME_SET_PREFIX = "set";
    private static final String RESOURCE_PREFIX = "save_";
    private static final int NAME_SAVE_PFX_LEN = "save".length();
    private SampleSaveConfiguration saveConfig;

    public SavePropertyDialog() {
        log.warn("Constructor only intended for use in testing");
    }

    public SavePropertyDialog(Frame owner, String title, boolean modal, SampleSaveConfiguration s) {
        super(owner, title, modal);
        this.saveConfig = s;
        log.debug("SampleSaveConfiguration = " + this.saveConfig);
        this.initDialog();
    }

    private int countMethods(Method[] m) {
        int count = 0;
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().startsWith(NAME_SAVE_PFX)) continue;
            ++count;
        }
        return count;
    }

    private void initDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        Method[] methods = SampleSaveConfiguration.class.getMethods();
        int x = this.countMethods(methods) / 3 + 1;
        log.debug("grid panel is 3 by " + x);
        JPanel checkPanel = new JPanel(new GridLayout(x, 3));
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith(NAME_SAVE_PFX) || methods[i].getParameterTypes().length != 0) continue;
            try {
                name = name.substring(NAME_SAVE_PFX_LEN);
                JCheckBox check = new JCheckBox(JMeterUtils.getResString(RESOURCE_PREFIX + name), (boolean)((Boolean)methods[i].invoke((Object)this.saveConfig, new Object[0])));
                checkPanel.add((Component)check, "North");
                check.addActionListener(this);
                String actionCommand = NAME_SET_PREFIX + name;
                check.setActionCommand(actionCommand);
                if (functors.containsKey(actionCommand)) continue;
                functors.put(actionCommand, new Functor(actionCommand));
                continue;
            }
            catch (IllegalAccessException e) {
                log.warn("Problem creating save config dialog", (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                log.warn("Problem creating save config dialog", (Throwable)e);
            }
        }
        this.getContentPane().add((Component)checkPanel, "North");
        JButton exit = new JButton(JMeterUtils.getResString("done"));
        this.getContentPane().add((Component)exit, "South");
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SavePropertyDialog.this.dispose();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        Functor f = functors.get(action);
        f.invoke((Object)this.saveConfig, new Object[]{((JCheckBox)e.getSource()).isSelected()});
    }

    public SampleSaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    public void setSaveConfig(SampleSaveConfiguration saveConfig) {
        this.saveConfig = saveConfig;
    }
}

