/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;

public class LoopController
extends GenericController
implements Serializable {
    private static final String LOOPS = "LoopController.loops";
    private static final long serialVersionUID = 232L;
    private static final String CONTINUE_FOREVER = "LoopController.continue_forever";
    private transient int loopCount = 0;

    public LoopController() {
        this.setContinueForever_private(true);
    }

    public void setLoops(int loops) {
        this.setProperty(new IntegerProperty(LOOPS, loops));
    }

    public void setLoops(String loopValue) {
        this.setProperty(new StringProperty(LOOPS, loopValue));
    }

    public int getLoops() {
        try {
            JMeterProperty prop = this.getProperty(LOOPS);
            return Integer.parseInt(prop.getStringValue());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getLoopString() {
        return this.getPropertyAsString(LOOPS);
    }

    public void setContinueForever(boolean forever) {
        this.setContinueForever_private(forever);
    }

    private void setContinueForever_private(boolean forever) {
        this.setProperty(new BooleanProperty(CONTINUE_FOREVER, forever));
    }

    private boolean getContinueForever() {
        return this.getPropertyAsBoolean(CONTINUE_FOREVER);
    }

    public Sampler next() {
        if (this.endOfLoop()) {
            if (!this.getContinueForever()) {
                this.setDone(true);
            }
            return null;
        }
        return super.next();
    }

    private boolean endOfLoop() {
        int loops = this.getLoops();
        return loops > -1 && this.loopCount >= loops;
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop()) {
            if (!this.getContinueForever()) {
                this.setDone(true);
            } else {
                this.resetLoopCount();
            }
            return null;
        }
        return this.next();
    }

    public void triggerEndOfLoop() {
        super.triggerEndOfLoop();
        this.resetLoopCount();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        this.loopCount = 0;
    }

    protected int getIterCount() {
        return this.loopCount + 1;
    }

    protected void reInitialize() {
        this.setFirst(true);
        this.resetCurrent();
        this.incrementLoopCount();
        this.recoverRunningVersion();
    }

    public void startNextLoop() {
        this.reInitialize();
    }
}

