/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.dislserver;

import ch.usi.dag.disl.DiSL;
import ch.usi.dag.disl.exception.DiSLException;
import ch.usi.dag.dislserver.DiSLServer;
import ch.usi.dag.dislserver.DiSLServerException;
import ch.usi.dag.dislserver.NetMessage;
import ch.usi.dag.dislserver.NetMessageReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class Worker
extends Thread {
    private static final boolean debug = Boolean.getBoolean("debug");
    private static final String PROP_UNINSTR = "dislserver.uninstrumented";
    private static final String uninstrPath = System.getProperty("dislserver.uninstrumented", null);
    private static final String PROP_INSTR = "dislserver.instrumented";
    private static final String instrPath = System.getProperty("dislserver.instrumented", null);
    private static final byte[] emptyByteArray = new byte[0];
    private final NetMessageReader sc;
    private final DiSL disl;
    private final AtomicLong instrumentationTime = new AtomicLong();

    Worker(NetMessageReader sc, DiSL disl) {
        this.sc = sc;
        this.disl = disl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.instrumentationLoop();
            this.sc.close();
        }
        catch (Throwable e) {
            DiSLServer.reportError(e);
        }
        finally {
            DiSLServer.workerDone(this.instrumentationTime.get());
        }
    }

    private void instrumentationLoop() throws Exception {
        try {
            while (true) {
                byte[] instrClass;
                NetMessage nm;
                if ((nm = this.sc.readMessage()).getControl().length == 0 && nm.getClassCode().length == 0) {
                    return;
                }
                try {
                    long startTime = System.nanoTime();
                    instrClass = this.instrument(new String(nm.getControl()), nm.getClassCode());
                    this.instrumentationTime.addAndGet(System.nanoTime() - startTime);
                }
                catch (Exception e) {
                    String errToReport = e.getMessage();
                    if (debug) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        errToReport = sw.toString();
                    }
                    String errMsg = "Instrumentation error for class " + new String(nm.getControl()) + ": " + errToReport;
                    this.sc.sendMessage(new NetMessage(errMsg.getBytes(), emptyByteArray));
                    throw e;
                }
                NetMessage replyData = null;
                replyData = instrClass != null ? new NetMessage(emptyByteArray, instrClass) : new NetMessage(emptyByteArray, emptyByteArray);
                this.sc.sendMessage(replyData);
            }
        }
        catch (IOException e) {
            throw new DiSLServerException(e);
        }
    }

    private byte[] instrument(String className, byte[] origCode) throws DiSLServerException, DiSLException {
        if (className == null || className.isEmpty()) {
            className = UUID.randomUUID().toString();
        }
        if (uninstrPath != null) {
            this.dump(className, origCode, uninstrPath);
        }
        byte[] instrCode = this.disl.instrument(origCode);
        if (instrPath != null && instrCode != null) {
            this.dump(className, instrCode, instrPath);
        }
        return instrCode;
    }

    private void dump(String className, byte[] codeAsBytes, String path) throws DiSLServerException {
        try {
            int i = className.lastIndexOf(47);
            String onlyClassName = className.substring(i + 1);
            String packageName = className.substring(0, i + 1);
            String pathWithPkg = path + File.separator + packageName;
            new File(pathWithPkg).mkdirs();
            FileOutputStream fo = new FileOutputStream(pathWithPkg + onlyClassName + ".class");
            fo.write(codeAsBytes);
            fo.close();
        }
        catch (FileNotFoundException e) {
            throw new DiSLServerException(e);
        }
        catch (IOException e) {
            throw new DiSLServerException(e);
        }
    }
}

