/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.dislserver;

import ch.usi.dag.dislserver.NetMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class NetMessageReader {
    private final Socket socket;
    private final DataInputStream is;
    private final DataOutputStream os;

    public NetMessageReader(Socket socket) throws IOException {
        this.socket = socket;
        this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public NetMessage readMessage() throws IOException {
        int controlLength = this.is.readInt();
        int classCodeLength = this.is.readInt();
        byte[] control = new byte[controlLength];
        byte[] classCode = new byte[classCodeLength];
        this.is.readFully(control);
        this.is.readFully(classCode);
        return new NetMessage(control, classCode);
    }

    public void close() throws IOException {
        this.is.close();
        this.socket.close();
    }

    public void sendMessage(NetMessage nm) throws IOException {
        this.os.writeInt(nm.getControl().length);
        this.os.writeInt(nm.getClassCode().length);
        this.os.write(nm.getControl());
        this.os.write(nm.getClassCode());
        this.os.flush();
    }
}

