/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.dislserver;

import ch.usi.dag.disl.DiSL;
import ch.usi.dag.disl.exception.DiSLException;
import ch.usi.dag.disl.exception.DiSLInMethodException;
import ch.usi.dag.dislserver.DiSLServerException;
import ch.usi.dag.dislserver.NetMessageReader;
import ch.usi.dag.dislserver.Worker;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class DiSLServer {
    public static final String PROP_DEBUG = "debug";
    private static final boolean debug = Boolean.getBoolean("debug");
    private static final String PROP_PORT = "dislserver.port";
    private static final int DEFAULT_PORT = 11217;
    private static final int port = Integer.getInteger("dislserver.port", 11217);
    private static final String PROP_TIME_STAT = "dislserver.timestat";
    private static final boolean timeStat = Boolean.getBoolean("dislserver.timestat");
    private static final String PROP_CONT = "dislserver.continuous";
    private static final boolean continuous = Boolean.getBoolean("dislserver.continuous");
    private static final String PROP_BYPASS = "dislserver.disablebypass";
    private static final boolean bypass = !Boolean.getBoolean("dislserver.disablebypass");
    private static final AtomicInteger aliveWorkers = new AtomicInteger();
    private static final AtomicLong instrumentationTime = new AtomicLong();
    private static DiSL disl;
    private static ServerSocket listenSocket;

    public static void main(String[] args) {
        try {
            disl = new DiSL(bypass);
            if (debug) {
                System.out.println("DiSL: starting instrumentation server...");
            }
            listenSocket = new ServerSocket(port);
            if (debug) {
                System.out.printf("DiSL: listening at %s:%d\n", listenSocket.getInetAddress().getHostAddress(), listenSocket.getLocalPort());
            }
            while (true) {
                Socket newClient = listenSocket.accept();
                if (debug) {
                    System.out.printf("DiSL: accepting connection from %s:%d\n", newClient.getInetAddress().getHostAddress(), newClient.getPort());
                }
                NetMessageReader sc = new NetMessageReader(newClient);
                aliveWorkers.incrementAndGet();
                new Worker(sc, disl).start();
            }
        }
        catch (IOException ioe) {
            DiSLServer.reportError(new DiSLServerException(ioe));
        }
        catch (Throwable throwable) {
            DiSLServer.reportError(throwable);
        }
    }

    private static void reportInnerError(Throwable throwable) {
        for (Throwable cause = throwable.getCause(); cause != null && cause.getMessage() != null; cause = cause.getCause()) {
            System.err.println("  Inner error: " + cause.getMessage());
        }
    }

    public static void reportError(Throwable throwable) {
        if (throwable instanceof DiSLException) {
            System.err.print("DiSL: error");
            if (throwable instanceof DiSLInMethodException) {
                System.err.printf(" (while instrumenting method \"%s\")", throwable.getMessage());
                throwable = throwable.getCause();
            }
            DiSLServer.reportOptionalMessage(throwable);
            DiSLServer.reportInnerError(throwable);
            if (debug) {
                throwable.printStackTrace();
            }
        } else if (throwable instanceof DiSLServerException) {
            System.err.print("DiSL: server error");
            DiSLServer.reportOptionalMessage(throwable);
            DiSLServer.reportInnerError(throwable);
            if (debug) {
                throwable.printStackTrace();
            }
        } else {
            System.err.print("DiSL: fatal error: ");
            throwable.printStackTrace();
        }
    }

    private static void reportOptionalMessage(Throwable throwable) {
        String message = throwable.getMessage();
        System.err.println(message != null ? ": " + message : "");
    }

    public static void workerDone(long instrTime) {
        instrumentationTime.addAndGet(instrTime);
        if (aliveWorkers.decrementAndGet() == 0) {
            if (timeStat) {
                System.out.printf("DiSL: instrumentation took %d milliseconds\n", instrumentationTime.get() / 1000000L);
            }
            if (!continuous) {
                disl.terminate();
                if (debug) {
                    System.out.println("DiSL: shutting down instrumentation server...");
                }
                System.exit(0);
            }
        }
    }
}

